/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.server.extensions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.server.CarbonLaunchExtension;
import org.wso2.carbon.server.util.Utils;

public class Log4jPropFileFragmentBundleCreator
implements CarbonLaunchExtension {
    private static Log log = LogFactory.getLog(Log4jPropFileFragmentBundleCreator.class);
    private static String LOG4J_PROP_FILE_NAME = "log4j.properties";
    private static String FRAGMENT_BUNDLE_NAME = "org.wso2.carbon.logging.propfile";
    private static String FRAGMENT_BUNDLE_VERSION = "1.0.0";
    private static String FRAGMENT_HOST_BUNDLE_NAME = "org.wso2.carbon.logging";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void perform() {
        try {
            Manifest mf = new Manifest();
            Attributes attribs = mf.getMainAttributes();
            attribs.putValue("Manifest-Version", "1.0");
            attribs.putValue("Bundle-ManifestVersion", "2");
            attribs.putValue("Bundle-Name", FRAGMENT_BUNDLE_NAME);
            attribs.putValue("Bundle-SymbolicName", FRAGMENT_BUNDLE_NAME);
            attribs.putValue("Bundle-Version", FRAGMENT_BUNDLE_VERSION);
            attribs.putValue("Fragment-Host", FRAGMENT_HOST_BUNDLE_NAME);
            attribs.putValue("Bundle-ClassPath", ".");
            File confFolder = new File(Utils.getCarbonComponentRepo(), "../conf");
            String loggingPropFilePath = confFolder.getAbsolutePath() + File.separator + LOG4J_PROP_FILE_NAME;
            File dropinsFolder = new File(Utils.getCarbonComponentRepo(), "dropins");
            String targetFilePath = dropinsFolder.getAbsolutePath() + File.separator + FRAGMENT_BUNDLE_NAME + "_" + FRAGMENT_BUNDLE_VERSION + ".jar";
            String tempDirPath = Utils.JAR_TO_BUNDLE_DIR + File.separator + System.currentTimeMillis() + Math.random();
            FileOutputStream mfos = null;
            try {
                Utils.copyFileToDir(new File(loggingPropFilePath), new File(tempDirPath));
                String metaInfPath = tempDirPath + File.separator + "META-INF";
                if (!new File(metaInfPath).mkdirs()) {
                    throw new IOException("Failed to create the directory: " + metaInfPath);
                }
                mfos = new FileOutputStream(metaInfPath + File.separator + "MANIFEST.MF");
                mf.write(mfos);
                Utils.archiveDir(targetFilePath, tempDirPath);
                Utils.deleteDir(new File(tempDirPath));
            }
            finally {
                try {
                    if (mfos != null) {
                        mfos.close();
                    }
                }
                catch (IOException e) {
                    log.error((Object)("Unable to close the OutputStream " + e.getMessage()), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Error occured while creating the log4j prop fragment bundle.", (Throwable)e);
        }
    }
}

