/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.osgi.framework.Bundle;
import org.wso2.carbon.ui.BundleProxyClassLoader;
import org.wso2.carbon.ui.JSPContextFinder;
import org.wso2.carbon.ui.JspServlet;
import org.wso2.carbon.ui.internal.CarbonUIServiceComponent;

public class JspClassLoader
extends URLClassLoader {
    private static final Bundle JASPERBUNDLE = CarbonUIServiceComponent.getBundle(JspServlet.class);
    private static final ClassLoader PARENT = JspClassLoader.class.getClassLoader().getParent();
    private static final String JAVA_PACKAGE = "java.";
    private static final ClassLoader EMPTY_CLASSLOADER = new ClassLoader(null){

        @Override
        public URL getResource(String name) {
            return null;
        }

        public Enumeration findResources(String name) throws IOException {
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }

        public Class loadClass(String name) throws ClassNotFoundException {
            throw new ClassNotFoundException(name);
        }
    };
    private PermissionCollection permissions;

    public JspClassLoader(Bundle bundle, PermissionCollection permissions) {
        super(new URL[0], (ClassLoader)new BundleProxyClassLoader(bundle, (ClassLoader)new BundleProxyClassLoader(JASPERBUNDLE, (ClassLoader)new JSPContextFinder(EMPTY_CLASSLOADER))));
        this.permissions = permissions;
        this.addBundleClassPathJars(bundle);
    }

    private void addBundleClassPathJars(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String classPath = (String)headers.get("Bundle-ClassPath");
        if (classPath != null) {
            StringTokenizer tokenizer = new StringTokenizer(classPath, ",");
            while (tokenizer.hasMoreTokens()) {
                URL entry;
                String candidate = tokenizer.nextToken().trim();
                if (!candidate.endsWith(".jar") || (entry = bundle.getEntry(candidate)) == null) continue;
                try {
                    URL jarEntryURL = new URL("jar:" + entry.toString() + "!/");
                    super.addURL(jarEntryURL);
                }
                catch (MalformedURLException e) {}
            }
        }
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (PARENT != null && name.startsWith(JAVA_PACKAGE)) {
            return PARENT.loadClass(name);
        }
        return super.loadClass(name, resolve);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        throw new ClassNotFoundException(name);
    }

    @Override
    protected PermissionCollection getPermissions(CodeSource codesource) {
        return this.permissions;
    }
}

