/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.tracker;

import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.wso2.carbon.ui.CarbonUIAuthenticator;
import org.wso2.carbon.ui.tracker.AuthenticatorComparator;

public class AuthenticatorRegistry {
    private static Log log = LogFactory.getLog(AuthenticatorRegistry.class);
    private static ServiceTracker authTracker;
    private static CarbonUIAuthenticator[] authenticators;
    private static Object lock;
    public static final String AUTHENTICATOR_TYPE = "authenticator.type";

    public static void init(BundleContext bc) throws Exception {
        try {
            authTracker = new ServiceTracker(bc, CarbonUIAuthenticator.class.getName(), null);
            authTracker.open();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CarbonUIAuthenticator getCarbonAuthenticator(HttpServletRequest request) {
        HttpSession session = request.getSession();
        CarbonUIAuthenticator authenticator = (CarbonUIAuthenticator)session.getAttribute("CarbonAuthenticator");
        if (authenticator != null) {
            return authenticator;
        }
        if (authenticators == null || authenticators.length == 0 || authenticators[0] == null) {
            Object object = lock;
            synchronized (object) {
                if (authenticators == null || authenticators.length == 0 || authenticators[0] == null) {
                    Object[] objects = authTracker.getServices();
                    authenticators = new CarbonUIAuthenticator[objects.length];
                    int i = 0;
                    for (Object obj : objects) {
                        AuthenticatorRegistry.authenticators[i] = (CarbonUIAuthenticator)obj;
                        ++i;
                    }
                    Arrays.sort(authenticators, new AuthenticatorComparator());
                }
            }
        }
        for (CarbonUIAuthenticator auth : authenticators) {
            if (auth.isDisabled() || !auth.canHandle(request)) continue;
            session.setAttribute("CarbonAuthenticator", (Object)auth);
            return auth;
        }
        return null;
    }

    static {
        lock = new Object();
    }
}

