/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ui.transports;

import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.ui.util.FileDownloadUtil;
import org.wso2.carbon.utils.ConfigurationContextService;

public class FileDownloadServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(FileDownloadServlet.class);
    private static final long serialVersionUID = 6074514253507510250L;
    private FileDownloadUtil fileDownloadUtil;
    private BundleContext context;
    private ConfigurationContextService configContextService;
    private ServletConfig servletConfig;

    public FileDownloadServlet(BundleContext context, ConfigurationContextService configContextService) {
        this.context = context;
        this.configContextService = configContextService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        res.setStatus(406);
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        try {
            this.fileDownloadUtil.acquireResource(this.configContextService, req, res);
        }
        catch (CarbonException e) {
            String msg = "Cannot download file";
            log.error((Object)msg, (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        this.servletConfig = servletConfig;
        this.fileDownloadUtil = new FileDownloadUtil(this.context);
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }
}

