/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.app;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.app.Utils;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.secure.AuthorizationFailedException;
import org.wso2.carbon.registry.core.session.CurrentSession;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.registry.core.utils.AuthorizationUtils;
import org.wso2.carbon.registry.core.utils.RegistryUtils;

public class ResourceServlet
extends HttpServlet {
    private static final Log log = LogFactory.getLog(ResourceServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Resource resource;
            String uri = request.getRequestURI();
            int idx = uri.indexOf("resource");
            String path = uri.substring(idx + 8);
            if (path == null) {
                String msg = "Could not get the resource content. Path is not specified.";
                log.error((Object)msg);
                response.setStatus(400);
                return;
            }
            try {
                UserRegistry registry = Utils.getRegistry(request);
                try {
                    path = new URI(path).normalize().toString();
                }
                catch (URISyntaxException e) {
                    log.error((Object)("Unable to normalize requested resource path: " + path), (Throwable)e);
                }
                String decodedPath = URLDecoder.decode(path, "utf-8");
                CurrentSession.setUserRealm(registry.getUserRealm());
                CurrentSession.setUser(registry.getUserName());
                try {
                    if (!AuthorizationUtils.authorize(RegistryUtils.getAbsolutePath(registry.getRegistryContext(), decodedPath), "http://www.wso2.org/projects/registry/actions/get")) {
                        response.setStatus(401);
                        response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                        return;
                    }
                    resource = registry.get(decodedPath);
                }
                finally {
                    CurrentSession.removeUserRealm();
                    CurrentSession.removeUser();
                }
            }
            catch (AuthorizationFailedException e) {
                log.error((Object)e.getMessage());
                response.setStatus(401);
                response.setHeader("WWW-Authenticate", "Basic realm=\"WSO2-Registry\"");
                return;
            }
            catch (RegistryException e) {
                String msg = "Error retrieving the resource " + path + ". " + e.getMessage();
                log.error((Object)msg, (Throwable)((Object)e));
                throw e;
            }
            if (resource instanceof Collection) {
                String msg = "Could not get the resource content. Path " + path + " refers to a collection.";
                log.error((Object)msg);
                response.setStatus(501);
                return;
            }
            long ifModifiedSinceValue = request.getDateHeader("If-Modified-Since");
            long lastModifiedValue = resource.getLastModified().getTime();
            if (ifModifiedSinceValue > 0L && (ifModifiedSinceValue /= 1000L) >= (lastModifiedValue /= 1000L)) {
                response.setStatus(304);
                return;
            }
            response.setDateHeader("Last-Modified", lastModifiedValue);
            String ifNonMatchValue = request.getHeader("if-none-match");
            String currentETag = Utils.calculateEntityTag(resource);
            if (ifNonMatchValue != null && ifNonMatchValue.equals(currentETag)) {
                response.setStatus(304);
                return;
            }
            response.setHeader("ETag", currentETag);
            if (resource.getMediaType() != null && resource.getMediaType().length() > 0) {
                response.setContentType(resource.getMediaType());
            } else {
                response.setHeader("Content-Disposition", "attachment; filename=" + RegistryUtils.getResourceName(path));
                response.setContentType("application/download");
            }
            InputStream contentStream = null;
            if (resource.getContent() != null) {
                contentStream = resource.getContentStream();
            }
            if (contentStream != null) {
                try {
                    int byteCount;
                    ServletOutputStream servletOutputStream = response.getOutputStream();
                    byte[] contentChunk = new byte[1024];
                    while ((byteCount = contentStream.read(contentChunk)) != -1) {
                        servletOutputStream.write(contentChunk, 0, byteCount);
                    }
                    response.flushBuffer();
                    servletOutputStream.flush();
                }
                finally {
                    contentStream.close();
                }
            } else {
                Object content = resource.getContent();
                if (content != null) {
                    if (content instanceof byte[]) {
                        ServletOutputStream servletOutputStream = response.getOutputStream();
                        servletOutputStream.write((byte[])content);
                        response.flushBuffer();
                        servletOutputStream.flush();
                    } else {
                        PrintWriter writer = response.getWriter();
                        writer.write(content.toString());
                        writer.flush();
                    }
                }
            }
            resource.discard();
        }
        catch (RegistryException e) {
            String msg = "Failed to get resource content. " + e.getMessage();
            log.error((Object)msg, (Throwable)((Object)e));
            response.setStatus(500);
        }
    }
}

