/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core;

import java.util.Arrays;
import java.util.LinkedHashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.CollectionVersionImpl;
import org.wso2.carbon.registry.core.Comment;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataobjects.ResourceDO;

public class CollectionImpl
extends ResourceImpl
implements Collection {
    private static final Log log = LogFactory.getLog(CollectionImpl.class);
    protected int childCount;

    public CollectionImpl() {
        this.childCount = -1;
    }

    public CollectionImpl(String[] paths) {
        try {
            this.setChildren(paths);
        }
        catch (RegistryException e) {
            log.warn((Object)"Unable to set child paths to this collection.", (Throwable)((Object)e));
        }
    }

    public CollectionImpl(String path, ResourceDO resourceDO) {
        super(path, resourceDO);
        this.childCount = -1;
    }

    public CollectionImpl(CollectionImpl collection) {
        super(collection);
        if (this.content != null) {
            if (this.content instanceof String[]) {
                String[] paths = (String[])this.content;
                int length = paths.length;
                String[] output = new String[length];
                System.arraycopy(paths, 0, output, 0, length);
                this.content = output;
            } else if (this.content instanceof Comment[]) {
                Comment[] paths = (Comment[])this.content;
                int length = paths.length;
                Comment[] output = new Comment[length];
                System.arraycopy(paths, 0, output, 0, length);
                for (int i = 0; i < length; ++i) {
                    output[i] = new Comment(output[i]);
                }
                this.content = output;
            } else if (this.content instanceof Resource[]) {
                Resource[] paths = (Resource[])this.content;
                int length = paths.length;
                Resource[] output = new Resource[length];
                System.arraycopy(paths, 0, output, 0, length);
                for (int i = 0; i < length; ++i) {
                    if (output[i] instanceof CollectionVersionImpl) {
                        output[i] = new CollectionVersionImpl((CollectionVersionImpl)output[i]);
                        continue;
                    }
                    if (output[i] instanceof CollectionImpl) {
                        output[i] = new CollectionImpl((CollectionImpl)output[i]);
                        continue;
                    }
                    if (output[i] instanceof Comment) {
                        output[i] = new Comment((Comment)output[i]);
                        continue;
                    }
                    if (!(output[i] instanceof ResourceImpl)) continue;
                    output[i] = new ResourceImpl((ResourceImpl)output[i]);
                }
                this.content = output;
            }
        }
        this.childCount = collection.childCount;
    }

    @Override
    public void setContent(Object content) throws RegistryException {
        if (content == null) {
            return;
        }
        if (content instanceof String[]) {
            super.setContentWithNoUpdate(content);
            this.childCount = ((String[])content).length;
            return;
        }
        if (content instanceof Resource[]) {
            super.setContentWithNoUpdate(content);
            this.childCount = ((Resource[])content).length;
            return;
        }
        if (content instanceof String) {
            super.setContentWithNoUpdate(content);
            return;
        }
        throw new IllegalArgumentException("Invalid content for collection. Content of type " + content.getClass().toString() + " is not allowed for collections.");
    }

    @Override
    public void setContentWithNoUpdate(Object content) throws RegistryException {
        if (content == null) {
            return;
        }
        if (content instanceof String[] || content instanceof Resource[] || content instanceof String) {
            super.setContentWithNoUpdate(content);
            return;
        }
        throw new IllegalArgumentException("Invalid content for collection. Content of type " + content.getClass().toString() + " is not allowed for collections.");
    }

    @Override
    public void setChildren(String[] paths) throws RegistryException {
        String[] temp;
        this.content = temp = this.fixPaths(paths);
        this.childCount = temp.length;
    }

    @Override
    public String[] getChildren() throws RegistryException {
        if (this.getContent() instanceof String[]) {
            return this.fixPaths((String[])this.getContent());
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[] getChildren(int start, int pageLen) throws RegistryException {
        this.setSessionInformation();
        try {
            if (this.content == null) {
                if (this.resourceDAO == null) {
                    String msg = "The data access object for resources has not been created.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                String[] msg = this.fixPaths(this.resourceDAO.getChildren(this, start, pageLen, this.dataAccessManager));
                return msg;
            }
            if (this.content instanceof String[]) {
                String[] childNodes = (String[])this.content;
                int limit = start + pageLen;
                if (start > childNodes.length) {
                    String[] stringArray = new String[]{};
                    return stringArray;
                }
                if (limit > childNodes.length) {
                    limit = childNodes.length;
                }
                String[] stringArray = this.fixPaths(Arrays.copyOfRange(childNodes, start, limit));
                return stringArray;
            }
            String[] stringArray = new String[]{};
            return stringArray;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getChildCount() throws RegistryException {
        try {
            this.setSessionInformation();
            if (this.childCount != -1) {
                int n = this.childCount;
                return n;
            }
            if (this.content != null && this.content instanceof String[]) {
                String[] childPaths = (String[])this.content;
                int n = this.fixPaths(childPaths).length;
                return n;
            }
            if (this.resourceDAO == null) {
                String msg = "The data access object for resources has not been created.";
                log.error((Object)msg);
                throw new RegistryException(msg);
            }
            int n = this.resourceDAO.getChildCount(this, this.dataAccessManager);
            return n;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    public void setChildCount(int count) {
        this.childCount = count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getContent() throws RegistryException {
        this.setSessionInformation();
        try {
            if (this.content == null) {
                if (this.resourceDAO == null) {
                    String msg = "The data access object for resources has not been created.";
                    log.error((Object)msg);
                    throw new RegistryException(msg);
                }
                this.resourceDAO.fillChildren(this, this.dataAccessManager);
            }
            Object object = this.content;
            return object;
        }
        finally {
            this.clearSessionInformation();
        }
    }

    @Override
    public ResourceImpl getShallowCopy() throws RegistryException {
        CollectionImpl newCollection = new CollectionImpl();
        this.fillCollectionCopy(newCollection);
        return newCollection;
    }

    public void fillCollectionCopy(CollectionImpl collection) throws RegistryException {
        super.fillResourceCopy(collection);
        collection.setChildCount(this.childCount);
    }

    protected String[] fixPaths(String[] paths) {
        LinkedHashSet<String> temp = new LinkedHashSet<String>();
        for (String path : paths) {
            temp.add(path);
        }
        return temp.toArray(new String[temp.size()]);
    }
}

