/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.util.Date;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.RatingsDAO;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataobjects.RatingDO;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class RatingURLHandler
extends Handler {
    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        ResourceDAO resourceDAO = registryContext.getDataAccessManager().getDAOManager().getResourceDAO();
        RatingsDAO ratingsDAO = registryContext.getDataAccessManager().getDAOManager().getRatingsDAO(StaticConfiguration.isVersioningRatings());
        ResourcePath resourcePath = requestContext.getResourcePath();
        String ratedUserName = resourcePath.getParameterValue("ratings");
        if (ratedUserName != null) {
            ResourceImpl resourceImpl = resourceDAO.getResourceMetaData(resourcePath.getPath());
            RatingDO ratingDO = ratingsDAO.getRatingDO(resourceImpl, ratedUserName);
            int rating = ratingDO.getRating();
            Date ratedTime = ratingDO.getRatedTime();
            ResourceImpl resource = new ResourceImpl();
            resource.setMediaType("rating");
            resource.setContent(rating);
            resource.setAuthorUserName(ratedUserName);
            resource.setPath(resourcePath.getCompletePath());
            if (ratedTime != null) {
                resource.setCreatedTime(ratedTime);
                resource.setLastModified(ratedTime);
            }
            resource.addProperty("resourcePath", resourcePath.getPath());
            return resource;
        }
        return null;
    }
}

