/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.handlers.builtin;

import java.util.Date;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.registry.core.ResourceIDImpl;
import org.wso2.carbon.registry.core.ResourceImpl;
import org.wso2.carbon.registry.core.ResourcePath;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.config.StaticConfiguration;
import org.wso2.carbon.registry.core.dao.ResourceDAO;
import org.wso2.carbon.registry.core.dao.TagsDAO;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.core.jdbc.dataobjects.TaggingDO;
import org.wso2.carbon.registry.core.jdbc.handlers.Handler;
import org.wso2.carbon.registry.core.jdbc.handlers.RequestContext;

public class TagURLHandler
extends Handler {
    @Override
    public Resource get(RequestContext requestContext) throws RegistryException {
        RegistryContext registryContext = requestContext.getRegistryContext();
        if (registryContext == null) {
            registryContext = RegistryContext.getBaseInstance();
        }
        ResourceDAO resourceDAO = registryContext.getDataAccessManager().getDAOManager().getResourceDAO();
        TagsDAO tagsDAO = registryContext.getDataAccessManager().getDAOManager().getTagsDAO(StaticConfiguration.isVersioningTags());
        ResourcePath resourcePath = requestContext.getResourcePath();
        String tagDetails = resourcePath.getParameterValue("tags");
        if (tagDetails != null) {
            ResourceImpl resourceImpl;
            String[] queries = tagDetails.split(":");
            if (queries.length != 2) {
                return null;
            }
            String path = resourcePath.getPath();
            String tagName = queries[0];
            String userName = queries[1];
            TaggingDO taggingDO = null;
            ResourceIDImpl resourceIDImpl = resourceDAO.getResourceID(path);
            if (resourceIDImpl != null && (resourceImpl = resourceDAO.getResourceMetaData(resourceIDImpl)) != null) {
                TaggingDO[] taggingDOs = tagsDAO.getTagging(resourceImpl, tagName, userName);
                taggingDO = taggingDOs[0];
            }
            ResourceImpl resource = new ResourceImpl();
            resource.setMediaType("tag");
            resource.setPath(resourcePath.getCompletePath());
            if (taggingDO != null) {
                resource.setContent(taggingDO.getTagName());
                resource.setAuthorUserName(taggingDO.getTaggedUserName());
                Date taggedTime = taggingDO.getTaggedTime();
                resource.setCreatedTime(taggedTime);
                resource.setLastModified(taggedTime);
                resource.addProperty("resourcePath", taggingDO.getResourcePath());
            }
            requestContext.setProcessingComplete(true);
            return resource;
        }
        return null;
    }
}

