/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.realm;

import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.registry.core.config.Mount;
import org.wso2.carbon.registry.core.config.RegistryContext;
import org.wso2.carbon.registry.core.utils.RegistryUtils;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.Permission;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;

public class RegistryAuthorizationManager
implements AuthorizationManager {
    private UserRealm coreRealm;
    private Map<String, String> pathMap;

    public String computePathOnMount(String path) {
        for (Map.Entry<String, String> e : this.pathMap.entrySet()) {
            if (!path.startsWith(e.getKey())) continue;
            return e.getValue() + path.substring(e.getKey().length());
        }
        return path;
    }

    public RegistryAuthorizationManager(UserRealm coreRealm) {
        this.coreRealm = coreRealm;
        this.pathMap = new HashMap<String, String>();
        RegistryContext registryContext = RegistryContext.getBaseInstance();
        for (Mount mount : registryContext.getMounts()) {
            this.pathMap.put(mount.getPath(), mount.getTargetPath());
        }
    }

    @Deprecated
    public void clearUserAuthorization(String userName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().clearUserAuthorization(userName, unchrootedResourceId, action);
    }

    public void clearRoleAuthorization(String roleName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().clearRoleAuthorization(roleName, unchrootedResourceId, action);
    }

    @Deprecated
    public void authorizeUser(String userName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().authorizeUser(userName, unchrootedResourceId, action);
    }

    public void authorizeRole(String roleName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().authorizeRole(roleName, unchrootedResourceId, action);
    }

    public void authorizeRole(String roleName, Permission[] permissions) throws UserStoreException {
        for (Permission permission : permissions) {
            String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(permission.getResourceId()));
            permission.setResourceId(unchrootedResourceId);
        }
        this.getAuthorizationManager().authorizeRole(roleName, permissions);
    }

    public void clearResourceAuthorizations(String resourceId) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().clearResourceAuthorizations(unchrootedResourceId);
    }

    public boolean isUserAuthorized(String userName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().isUserAuthorized(userName, unchrootedResourceId, action);
    }

    public boolean isRoleAuthorized(String roleName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().isRoleAuthorized(roleName, unchrootedResourceId, action);
    }

    public String[] getAllowedRolesForResource(String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getAllowedRolesForResource(unchrootedResourceId, action);
    }

    public void denyRole(String roleName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().denyRole(roleName, unchrootedResourceId, action);
    }

    @Deprecated
    public void denyUser(String userName, String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        this.getAuthorizationManager().denyUser(userName, unchrootedResourceId, action);
    }

    public String[] getDeniedRolesForResource(String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getDeniedRolesForResource(unchrootedResourceId, action);
    }

    @Deprecated
    public String[] getExplicitlyAllowedUsersForResource(String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getExplicitlyAllowedUsersForResource(unchrootedResourceId, action);
    }

    @Deprecated
    public String[] getExplicitlyDeniedUsersForResource(String resourceId, String action) throws UserStoreException {
        String unchrootedResourceId = this.computePathOnMount(RegistryUtils.getUnChrootedPath(resourceId));
        return this.getAuthorizationManager().getExplicitlyDeniedUsersForResource(unchrootedResourceId, action);
    }

    public void clearRoleActionOnAllResources(String roleName, String action) throws UserStoreException {
        this.getAuthorizationManager().clearRoleActionOnAllResources(roleName, action);
    }

    public String[] getAllowedUIResourcesForUser(String userName, String permissionRootPath) throws UserStoreException {
        return this.getAuthorizationManager().getAllowedUIResourcesForUser(userName, permissionRootPath);
    }

    public void clearRoleAuthorization(String roleName) throws UserStoreException {
        this.getAuthorizationManager().clearRoleAuthorization(roleName);
    }

    @Deprecated
    public void clearUserAuthorization(String userName) throws UserStoreException {
        this.getAuthorizationManager().clearUserAuthorization(userName);
    }

    private AuthorizationManager getAuthorizationManager() throws UserStoreException {
        return this.coreRealm.getAuthorizationManager();
    }

    public int getTenantId() throws UserStoreException {
        return this.getAuthorizationManager().getTenantId();
    }

    public void resetPermissionOnUpdateRole(String roleName, String newRoleName) throws UserStoreException {
        this.getAuthorizationManager().resetPermissionOnUpdateRole(roleName, newRoleName);
    }
}

