/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.utils;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DumpReader
extends Reader {
    private static final Log log = LogFactory.getLog(DumpReader.class);
    private Reader reader;
    private int offset = 0;
    private boolean withinChildrenTag = false;
    private int childResourceLevel = 0;
    private boolean withinElementTag;
    private StringBuffer elementTagStrBuff;
    private List<Integer> localBuffer = null;
    private int localBufferStartIndex = -1;
    private int readingChildResourceIndex = -1;
    private int consumedChildResourceIndex = -1;
    private Map<Integer, Integer> resourceStartingBufferIndices;
    private Map<Integer, Integer> resourceEndingBufferIndices;
    private Map<Integer, Integer> resourceEndingOffset = new HashMap<Integer, Integer>();
    private static int totalRead = 0;
    private static int totalBuffered = 0;
    private static int maximumBuffer = 0;
    private static int totalBufferedRead = 0;
    private boolean checkingChildByParent = false;

    public DumpReader(Reader reader) {
        this.reader = reader;
    }

    @Override
    public int read(char[] cBuf, int off, int len) throws IOException {
        int r;
        int i;
        int cBufLen = cBuf.length;
        int minLen = cBufLen < len ? cBufLen : len;
        for (i = 0; i < minLen && (r = this.read()) != -1; ++i) {
            cBuf[i + off] = (char)r;
        }
        return i == 0 ? -1 : i;
    }

    @Override
    public int read() throws IOException {
        Integer endIndexObj;
        if (this.localBuffer != null && this.offset < this.localBufferStartIndex) {
            String msg = "Offset to ask should be always greater than the buffer start index.";
            log.error((Object)msg);
            throw new IOException(msg);
        }
        if (this.localBuffer != null && this.offset < this.localBufferStartIndex + this.localBuffer.size()) {
            int endIndex;
            Integer endIndexBufferObj;
            if (!this.checkingChildByParent && (endIndexBufferObj = this.resourceEndingBufferIndices.get(this.readingChildResourceIndex)) != null && (endIndex = this.localBufferStartIndex + endIndexBufferObj) < this.offset) {
                this.clearBufferUpToNow(endIndex);
                return -1;
            }
            int r = this.localBuffer.get(this.offset - this.localBufferStartIndex);
            if (!this.checkingChildByParent && this.offset - this.localBufferStartIndex > 1024) {
                this.clearBufferUpToNow(this.offset);
            }
            if (!(this.reader instanceof DumpReader)) {
                ++totalBufferedRead;
            }
            ++this.offset;
            return r;
        }
        if (!this.checkingChildByParent && this.localBuffer != null && this.readingChildResourceIndex >= this.consumedChildResourceIndex) {
            this.localBuffer = null;
            this.localBufferStartIndex = -1;
            this.resourceStartingBufferIndices = null;
            this.resourceEndingBufferIndices = null;
        }
        if (this.checkingChildByParent && this.localBuffer == null) {
            this.localBuffer = new ArrayList<Integer>();
            this.resourceStartingBufferIndices = new HashMap<Integer, Integer>();
            this.resourceEndingBufferIndices = new HashMap<Integer, Integer>();
            this.localBufferStartIndex = this.offset;
        }
        if (!this.checkingChildByParent && this.resourceEndingOffset != null && (endIndexObj = this.resourceEndingOffset.get(this.readingChildResourceIndex)) != null && endIndexObj < this.offset) {
            this.clearBufferUpToNow(endIndexObj);
            return -1;
        }
        int r = this.reader.read();
        ++this.offset;
        char c = (char)r;
        if (!(this.reader instanceof DumpReader)) {
            ++totalRead;
        }
        if (this.withinElementTag) {
            if (c == '>' && this.elementTagStrBuff == null) {
                String msg = "'>' found before '<'.";
                log.error((Object)msg);
                throw new IOException(msg);
            }
            this.elementTagStrBuff.append(c);
            if (c == '>') {
                this.withinElementTag = false;
                String elementTagStr = this.elementTagStrBuff.toString();
                this.elementTagStrBuff = null;
                if ("<children>".equals(elementTagStr) || "<childs>".equals(elementTagStr)) {
                    this.withinChildrenTag = true;
                } else if (elementTagStr.startsWith("</resource")) {
                    if (this.childResourceLevel == 1) {
                        if (this.localBuffer != null) {
                            this.resourceEndingBufferIndices.put(this.consumedChildResourceIndex, this.localBuffer.size());
                        }
                        this.resourceEndingOffset.put(this.consumedChildResourceIndex, this.offset - 1);
                    }
                    --this.childResourceLevel;
                } else if (this.withinChildrenTag && elementTagStr.startsWith("<resource")) {
                    ++this.childResourceLevel;
                    if (this.childResourceLevel == 1) {
                        ++this.consumedChildResourceIndex;
                        if (this.readingChildResourceIndex < this.consumedChildResourceIndex) {
                            if (this.localBuffer == null) {
                                this.localBuffer = new ArrayList<Integer>();
                                this.resourceStartingBufferIndices = new HashMap<Integer, Integer>();
                                this.resourceEndingBufferIndices = new HashMap<Integer, Integer>();
                            }
                            if (this.localBufferStartIndex == -1) {
                                byte[] elementTagStrBytes = elementTagStr.getBytes();
                                for (int i = 0; i < elementTagStrBytes.length - 1; ++i) {
                                    byte b = elementTagStrBytes[i];
                                    this.localBuffer.add(Integer.valueOf(b));
                                    if (this.reader instanceof DumpReader) continue;
                                    ++totalBuffered;
                                    maximumBuffer = this.localBuffer.size() > maximumBuffer ? this.localBuffer.size() : maximumBuffer;
                                }
                                this.localBufferStartIndex = this.offset - elementTagStr.length();
                            }
                            int currentLocalBufferIndex = this.localBuffer.size() + 1;
                            this.resourceStartingBufferIndices.put(this.consumedChildResourceIndex, currentLocalBufferIndex - elementTagStr.length());
                        }
                    }
                }
            }
        } else if (c == '<') {
            this.withinElementTag = true;
            this.elementTagStrBuff = new StringBuffer();
            this.elementTagStrBuff.append(c);
        }
        if (this.localBuffer != null) {
            this.localBuffer.add(r);
            if (!(this.reader instanceof DumpReader)) {
                ++totalBuffered;
                maximumBuffer = this.localBuffer.size() > maximumBuffer ? this.localBuffer.size() : maximumBuffer;
            }
        }
        return r;
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void setReadingChildResourceIndex(int readingChildResourceIndex) {
        this.readingChildResourceIndex = readingChildResourceIndex;
        if (this.resourceStartingBufferIndices != null && this.resourceStartingBufferIndices.get(readingChildResourceIndex) != null) {
            this.offset = this.localBufferStartIndex + this.resourceStartingBufferIndices.get(readingChildResourceIndex);
            if (!this.checkingChildByParent) {
                this.resourceStartingBufferIndices.remove(readingChildResourceIndex);
            }
        }
    }

    public void setCheckingChildByParent(boolean checkingChildByParent) {
        this.checkingChildByParent = checkingChildByParent;
    }

    public boolean isLastResource(int readingChildResourceIndex) throws IOException {
        int r;
        if (this.resourceEndingOffset.get(readingChildResourceIndex) == null) {
            throw new IOException("Error in checking the end of the resource index: " + readingChildResourceIndex + ".");
        }
        this.offset = this.resourceEndingOffset.get(readingChildResourceIndex) + 1;
        this.clearBufferUpToNow(this.offset);
        while ((r = this.read()) != -1 && r != 60) {
        }
        if (r == -1) {
            return true;
        }
        StringBuffer nextTagBuffer = new StringBuffer();
        nextTagBuffer.append((char)r);
        do {
            r = this.read();
            nextTagBuffer.append((char)r);
        } while (r != -1 && r != 62);
        if (r == -1) {
            return true;
        }
        String nextTag = nextTagBuffer.toString();
        if (nextTag.startsWith("<resource")) {
            return false;
        }
        while (true) {
            if ((r = this.read()) != -1 && r != 60) {
                continue;
            }
            if (r == -1) {
                return true;
            }
            nextTagBuffer = new StringBuffer();
            nextTagBuffer.append((char)r);
            do {
                r = this.read();
                nextTagBuffer.append((char)r);
            } while (r != -1 && r != 62);
            if (r == -1) {
                return true;
            }
            if (nextTagBuffer.toString().equals("</resource>")) break;
        }
        return true;
    }

    @Override
    public boolean ready() throws IOException {
        return this.localBuffer != null || this.reader.ready();
    }

    private void clearBufferUpToNow(int offset) {
        if (this.localBuffer != null) {
            if (offset >= this.localBufferStartIndex + this.localBuffer.size()) {
                this.localBuffer = null;
                this.localBufferStartIndex = -1;
                this.resourceStartingBufferIndices = null;
                this.resourceEndingBufferIndices = null;
            } else {
                int startOffset;
                List<Integer> newLocalBuffer = this.localBuffer.subList(offset - this.localBufferStartIndex, this.localBuffer.size());
                if (this.resourceStartingBufferIndices != null) {
                    HashMap<Integer, Integer> newResourceStartingBufferIndices = new HashMap<Integer, Integer>();
                    for (int resourceNo : this.resourceStartingBufferIndices.keySet()) {
                        int oldBufferStartIndex = this.resourceStartingBufferIndices.get(resourceNo);
                        startOffset = this.localBufferStartIndex + oldBufferStartIndex;
                        int newBuffStartIndex = startOffset - offset;
                        if (newBuffStartIndex < 0) continue;
                        newResourceStartingBufferIndices.put(resourceNo, newBuffStartIndex);
                    }
                    this.resourceStartingBufferIndices = newResourceStartingBufferIndices;
                }
                if (this.resourceEndingBufferIndices != null) {
                    HashMap<Integer, Integer> newResourceEndingBufferIndices = new HashMap<Integer, Integer>();
                    for (int resourceNo : this.resourceEndingBufferIndices.keySet()) {
                        int oldBufferEndIndex = this.resourceEndingBufferIndices.get(resourceNo);
                        startOffset = this.localBufferStartIndex + oldBufferEndIndex;
                        int newBuffEndIndex = startOffset - offset;
                        if (newBuffEndIndex < 0) continue;
                        newResourceEndingBufferIndices.put(resourceNo, newBuffEndIndex);
                    }
                    this.resourceEndingBufferIndices = newResourceEndingBufferIndices;
                }
                this.localBufferStartIndex = offset;
                this.localBuffer = newLocalBuffer;
            }
        }
    }

    public static int getTotalRead() {
        return totalRead;
    }

    public static int getTotalBuffered() {
        return totalBuffered;
    }

    public static int getMaxBufferedSize() {
        return maximumBuffer;
    }

    public static int getTotalBufferedRead() {
        return totalBufferedRead;
    }
}

