/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.registry.core.jdbc.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;

public class VersionRetriever {
    private InputStream inputStream;
    private List<Long> versionList;
    private int maxRetrievedVersion;
    private static final int SIZE_OF_BYTE = 8;
    private static final int SIZE_OF_LONG = 64;
    private static Log log = LogFactory.getLog(VersionRetriever.class);

    public VersionRetriever(InputStream inputStream) {
        this.inputStream = inputStream;
        this.versionList = new ArrayList<Long>();
        this.maxRetrievedVersion = -1;
    }

    public long getVersion(int versionIndex) throws RegistryException {
        while (versionIndex > this.maxRetrievedVersion) {
            long nextVersion = this.getNextVersion();
            if (nextVersion == 0L) {
                return -1L;
            }
            this.versionList.add(nextVersion);
            ++this.maxRetrievedVersion;
        }
        return this.versionList.get(versionIndex);
    }

    private long getNextVersion() throws RegistryException {
        int shiftLimit = 8;
        long versionValue = 0L;
        try {
            for (int i = 0; i < shiftLimit; ++i) {
                int nextByte = this.inputStream.read();
                if (i != 0) {
                    versionValue <<= 8;
                }
                versionValue |= (long)nextByte;
            }
        }
        catch (IOException e) {
            String msg = "Failed to read the stream to get the version value. " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, e);
        }
        return versionValue;
    }
}

