/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.Converter;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.OverrideByNameMapping;
import org.compass.core.mapping.osem.AbstractCollectionMapping;
import org.compass.core.mapping.osem.ArrayMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.CollectionMapping;
import org.compass.core.mapping.osem.ObjectMapping;

public class CollectionMappingProcessor
implements MappingProcessor {
    private ConverterLookup converterLookup;

    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        this.converterLookup = converterLookup;
        ArrayList<Mapping> colMappingsToAdd = new ArrayList<Mapping>();
        Iterator mappIt = compassMapping.mappingsIt();
        while (mappIt.hasNext()) {
            AliasMapping aliasMapping = (AliasMapping)mappIt.next();
            if (!(aliasMapping instanceof ClassMapping)) continue;
            colMappingsToAdd.clear();
            ClassMapping classMapping = (ClassMapping)aliasMapping;
            Iterator it = classMapping.mappingsIt();
            while (it.hasNext()) {
                Mapping maybeColMapping;
                ObjectMapping objectMapping;
                Mapping mapping = (Mapping)it.next();
                if (!(mapping instanceof ObjectMapping) || !(objectMapping = (ObjectMapping)mapping).canBeCollectionWrapped() || !((maybeColMapping = this.checkCollection(objectMapping)) instanceof AbstractCollectionMapping)) continue;
                colMappingsToAdd.add(maybeColMapping);
                it.remove();
            }
            for (Mapping mapping : colMappingsToAdd) {
                classMapping.addMapping(mapping);
            }
        }
        return compassMapping;
    }

    private Mapping checkCollection(ObjectMapping objectMapping) throws MappingException {
        Converter converter;
        AbstractCollectionMapping collectionMapping = null;
        Class collectionClass = objectMapping.getGetter().getReturnType();
        if (Collection.class.isAssignableFrom(collectionClass)) {
            collectionMapping = new CollectionMapping();
            if (List.class.isAssignableFrom(collectionClass)) {
                collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.LIST);
            } else if (LinkedHashSet.class.isAssignableFrom(collectionClass)) {
                collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.LINKED_HASH_SET);
            } else if (EnumSet.class.isAssignableFrom(collectionClass)) {
                collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.ENUM_SET);
            } else if (SortedSet.class.isAssignableFrom(collectionClass)) {
                collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.SORTED_SET);
            } else if (Set.class.isAssignableFrom(collectionClass)) {
                collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.SET);
            } else {
                collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.UNKNOWN);
            }
        } else if (collectionClass.isArray() && (converter = this.converterLookup.lookupConverter(objectMapping.getGetter().getReturnType())) == null) {
            collectionMapping = new ArrayMapping();
            collectionMapping.setCollectionType(AbstractCollectionMapping.CollectionType.NOT_REQUIRED);
        }
        if (collectionMapping != null) {
            collectionMapping.setElementMapping(objectMapping);
            collectionMapping.setGetter(objectMapping.getGetter());
            collectionMapping.setSetter(objectMapping.getSetter());
            collectionMapping.setName(objectMapping.getName());
            collectionMapping.setPath(objectMapping.getPath());
            collectionMapping.setPropertyName(objectMapping.getPropertyName());
            if (objectMapping instanceof OverrideByNameMapping) {
                collectionMapping.setOverrideByName(((OverrideByNameMapping)((Object)objectMapping)).isOverrideByName());
            } else {
                collectionMapping.setOverrideByName(true);
            }
            return collectionMapping;
        }
        return objectMapping;
    }
}

