/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.process;

import java.util.Iterator;
import org.compass.core.Property;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.process.MappingProcessor;
import org.compass.core.converter.ConverterLookup;
import org.compass.core.engine.naming.PropertyNamingStrategy;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.SpellCheckType;
import org.compass.core.mapping.internal.InternalAllMapping;
import org.compass.core.mapping.internal.InternalResourceMapping;
import org.compass.core.mapping.osem.ClassMapping;

public class ResolveLateAttributesPreLateBindingMappingProcessor
implements MappingProcessor {
    public CompassMapping process(CompassMapping compassMapping, PropertyNamingStrategy namingStrategy, ConverterLookup converterLookup, CompassSettings settings) throws MappingException {
        compassMapping.setPath(namingStrategy.getRootPath());
        Iterator it = compassMapping.mappingsIt();
        while (it.hasNext()) {
            ResourceMapping resourceMapping;
            ClassMapping classMapping;
            Mapping m = (Mapping)it.next();
            if (m instanceof ClassMapping && !(classMapping = (ClassMapping)m).isSupportUnmarshallSet()) {
                classMapping.setSupportUnmarshall(settings.getSettingAsBoolean("compass.osem.supportUnmarshall", true));
            }
            if (m instanceof ResourceMapping) {
                resourceMapping = (ResourceMapping)m;
                if (resourceMapping.getAllMapping().isSupported() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setSupported(settings.getSettingAsBoolean("compass.property.all.enabled", true));
                }
                if (resourceMapping.getAllMapping().isExcludeAlias() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setExcludeAlias(settings.getSettingAsBoolean("compass.property.all.excludeAlias", true));
                }
                if (resourceMapping.getAllMapping().isOmitNorms() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setOmitNorms(settings.getSettingAsBoolean("compass.property.all.omitNorms", false));
                }
                if (resourceMapping.getAllMapping().getProperty() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setProperty(settings.getSetting("compass.property.all", "zzz-all"));
                }
                if (resourceMapping.getAllMapping().getTermVector() == null) {
                    ((InternalAllMapping)resourceMapping.getAllMapping()).setTermVector(Property.TermVector.fromString(settings.getSetting("compass.property.all.termVector", Property.TermVector.NO.toString())));
                }
            }
            if (!(m instanceof InternalResourceMapping)) continue;
            resourceMapping = (InternalResourceMapping)m;
            SpellCheckType globablSpellCheck = SpellCheckType.fromString(settings.getSetting("compass.engine.spellcheck.defaultMode", "NA"));
            if (resourceMapping.getSpellCheck() != SpellCheckType.NA) continue;
            resourceMapping.setSpellCheck(globablSpellCheck);
        }
        return compassMapping;
    }
}

