/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.engine.utils;

import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;

public abstract class ResourceHelper {
    private ResourceHelper() {
    }

    public static Property[] toIds(Resource resource, CompassMapping mapping) throws SearchEngineException {
        ResourceMapping resourceMapping = mapping.getRootMappingByAlias(resource.getAlias());
        if (resourceMapping == null) {
            throw new SearchEngineException("Failed to find mappings for alias [" + resource.getAlias() + "]");
        }
        return ResourceHelper.toIds(resource, resourceMapping);
    }

    public static Property[] toIds(Resource resource, ResourceMapping resourceMapping) throws SearchEngineException {
        return ResourceHelper.toIds(resource, resourceMapping, true);
    }

    public static Property[] toIds(Resource resource, ResourceMapping resourceMapping, boolean idsMustExist) throws SearchEngineException {
        ResourcePropertyMapping[] pMappings = resourceMapping.getResourceIdMappings();
        Property[] ids = new Property[pMappings.length];
        for (int i = 0; i < pMappings.length; ++i) {
            ids[i] = resource.getProperty(pMappings[i].getPath().getPath());
            if (ids[i] == null) {
                if (!idsMustExist) {
                    return null;
                }
                throw new SearchEngineException("Id with path [" + pMappings[i].getPath().getPath() + "] for alias [" + resource.getAlias() + "] not found");
            }
            if (ids[i].isIndexed() && !ids[i].isTokenized() && ids[i].isStored()) continue;
            throw new SearchEngineException("Id [" + ids[i].getName() + "] for alias [" + resource.getAlias() + "] must be stored and un_tokenized");
        }
        return ids;
    }
}

