/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiSearcher;
import org.apache.lucene.search.Searchable;
import org.apache.lucene.search.Searcher;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.engine.SearchEngineInternalSearch;
import org.compass.core.lucene.engine.LuceneDelegatedClose;
import org.compass.core.lucene.engine.manager.LuceneIndexHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneSearchEngineInternalSearch
implements SearchEngineInternalSearch,
LuceneDelegatedClose {
    private Searcher searcher;
    protected IndexReader indexReader;
    private List<LuceneIndexHolder> indexHoldersToClose;
    private boolean closeReader;
    private boolean closeSearcher;
    private boolean closed;

    public LuceneSearchEngineInternalSearch() {
    }

    public LuceneSearchEngineInternalSearch(MultiSearcher searcher, List<LuceneIndexHolder> indexHolders) {
        this.searcher = searcher;
        this.indexHoldersToClose = indexHolders;
        Searchable[] searchables = searcher.getSearchables();
        IndexReader[] readers = new IndexReader[searchables.length];
        for (int i = 0; i < searchables.length; ++i) {
            readers[i] = ((IndexSearcher)searchables[i]).getIndexReader();
        }
        this.indexReader = new MultiReader(readers, false);
        this.closeReader = true;
        this.closeSearcher = true;
    }

    public LuceneSearchEngineInternalSearch(LuceneIndexHolder indexHolder, List<LuceneIndexHolder> indexHolders) {
        this.searcher = indexHolder.getIndexSearcher();
        this.indexReader = indexHolder.getIndexReader();
        this.indexHoldersToClose = indexHolders;
        this.closeReader = false;
        this.closeSearcher = false;
    }

    public LuceneSearchEngineInternalSearch(IndexReader indexReader, Searcher searcher, List<LuceneIndexHolder> indexHolders) {
        this.indexReader = indexReader;
        this.searcher = searcher;
        this.indexHoldersToClose = indexHolders;
        this.closeReader = true;
        this.closeSearcher = true;
    }

    public boolean isEmpty() {
        return this.searcher == null;
    }

    public Searcher getSearcher() {
        return this.searcher;
    }

    public IndexReader getReader() throws SearchEngineException {
        return this.indexReader;
    }

    @Override
    public void close() throws SearchEngineException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        if (this.searcher != null && this.closeSearcher) {
            try {
                this.searcher.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.indexReader != null && this.closeReader) {
            try {
                this.indexReader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.indexHoldersToClose != null) {
            for (LuceneIndexHolder indexHolder : this.indexHoldersToClose) {
                indexHolder.release();
            }
        }
    }
}

