/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.all;

import org.apache.lucene.index.Payload;

public class AllBoostUtils {
    public static final int _7BIT = 127;
    public static final int _6BIT = 63;
    public static final int _5BIT = 31;
    public static final int _4BIT = 15;
    public static final int BITN7 = 64;
    public static final int BITN8 = 128;
    public static final int FORBYTES = 65535;
    public static final int _8_7_BIT = 192;
    public static final int _8_7_6_BIT = 224;
    public static final int _SECOND_WORD = 240;
    public static final int _FULLY = 64;
    public static final int _MAX_LEN = 32;

    private AllBoostUtils() {
    }

    public static float readFloat(byte[] content) {
        int data = AllBoostUtils.readInt(content);
        return Float.intBitsToFloat(data);
    }

    public static Payload writeFloat(float data) {
        int idata = Float.floatToIntBits(data);
        return AllBoostUtils.writeInt(idata);
    }

    public static int readInt(byte[] content) {
        boolean sign;
        int index = 0;
        byte mbyte = content[index++];
        int num = mbyte & 0x3F;
        int len = 6;
        boolean bl = sign = (mbyte & 0x40) != 0;
        while ((mbyte & 0x80) != 0) {
            mbyte = content[index++];
            num |= (mbyte & 0x7F) << len;
            len += 7;
        }
        if (sign) {
            num ^= 0xFFFFFFFF;
        }
        return num;
    }

    public static Payload writeInt(int data) {
        byte[] buffer = new byte[32];
        int size = 0;
        int mbyte = 0;
        if (data < 0) {
            mbyte = 64;
            data ^= 0xFFFFFFFF;
        }
        mbyte |= (byte)(data & 0x3F);
        data >>>= 6;
        while (data != 0) {
            buffer[size++] = (byte)(mbyte |= 0x80);
            mbyte = data & 0x7F;
            data >>>= 7;
        }
        if (size == 0) {
            return new Payload(new byte[]{(byte)mbyte});
        }
        buffer[size++] = (byte)mbyte;
        return new Payload(buffer, 0, size);
    }
}

