/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.engine.analyzer.synonym;

import java.io.IOException;
import java.util.LinkedList;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.compass.core.lucene.engine.analyzer.synonym.SynonymLookupProvider;

public class SynonymFilter
extends TokenFilter {
    public static final String TOKEN_TYPE_SYNONYM = "SYNONYM";
    private LinkedList synonymStack;
    private SynonymLookupProvider synonymLookupProvider;

    public SynonymFilter(TokenStream in, SynonymLookupProvider synonymLookupProvider) {
        super(in);
        this.synonymLookupProvider = synonymLookupProvider;
        this.synonymStack = new LinkedList();
    }

    public Token next() throws IOException {
        if (this.synonymStack.size() > 0) {
            return (Token)this.synonymStack.removeFirst();
        }
        Token token = this.input.next();
        if (token == null) {
            return null;
        }
        this.addAliasesToStack(token);
        return token;
    }

    private void addAliasesToStack(Token token) {
        String[] synonyms = this.synonymLookupProvider.lookupSynonyms(token.termText());
        if (synonyms == null) {
            return;
        }
        for (int i = 0; i < synonyms.length; ++i) {
            Token synToken = new Token(synonyms[i], token.startOffset(), token.endOffset(), TOKEN_TYPE_SYNONYM);
            synToken.setPositionIncrement(0);
            this.synonymStack.addFirst(synToken);
        }
    }
}

