/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.PrefixFilter;
import org.apache.lucene.search.Query;

public class ConstantScorePrefixQuery
extends Query {
    private final Term prefix;

    public ConstantScorePrefixQuery(Term prefix) {
        this.prefix = prefix;
    }

    public Term getPrefix() {
        return this.prefix;
    }

    public Query rewrite(IndexReader reader) throws IOException {
        ConstantScoreQuery q = new ConstantScoreQuery(new PrefixFilter(this.prefix));
        q.setBoost(this.getBoost());
        return q;
    }

    public String toString(String field) {
        StringBuffer buffer = new StringBuffer();
        if (!this.prefix.field().equals(field)) {
            buffer.append(this.prefix.field());
            buffer.append(":");
        }
        buffer.append(this.prefix.text());
        buffer.append('*');
        if (this.getBoost() != 1.0f) {
            buffer.append("^");
            buffer.append(Float.toString(this.getBoost()));
        }
        return buffer.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConstantScorePrefixQuery)) {
            return false;
        }
        ConstantScorePrefixQuery other = (ConstantScorePrefixQuery)o;
        return this.prefix.equals(other.prefix) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        int h = this.prefix.hashCode() ^ Float.floatToIntBits(this.getBoost());
        h ^= h << 14 | h >>> 19;
        return h;
    }
}

