/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.metadata.ant;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.binding.XmlMetaDataBinding;
import org.compass.core.metadata.Alias;
import org.compass.core.metadata.MetaData;
import org.compass.core.metadata.impl.DefaultCompassMetaData;
import org.compass.core.metadata.impl.DefaultMetaDataGroup;
import org.compass.core.util.DTDEntityResolver;
import org.compass.core.util.config.ConfigurationHelper;
import org.compass.core.util.config.XmlConfigurationHelperBuilder;

public class MetaDataTask
extends Task {
    private File destDir;
    private FileSet fileset;

    public void setDestDir(File destDir) {
        this.destDir = destDir;
    }

    public void addFileset(FileSet fileset) {
        this.fileset = fileset;
    }

    public void execute() throws BuildException {
        DTDEntityResolver entityResolver = new DTDEntityResolver();
        DirectoryScanner ds = this.fileset.getDirectoryScanner(this.getProject());
        String[] files = ds.getIncludedFiles();
        File dir = this.fileset.getDir(this.getProject());
        for (int i = 0; i < files.length; ++i) {
            ConfigurationHelper conf;
            if (!files[i].endsWith("cmd.xml")) continue;
            File srcFile = new File(dir, files[i]);
            try {
                XmlConfigurationHelperBuilder builder = new XmlConfigurationHelperBuilder();
                builder.setEntityResolver(entityResolver);
                conf = builder.buildFromFile(srcFile);
            }
            catch (Exception e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            DefaultCompassMetaData compassMetaData = new DefaultCompassMetaData();
            XmlMetaDataBinding metaDataBinding = new XmlMetaDataBinding();
            metaDataBinding.setUpBinding(null, compassMetaData, new CompassSettings());
            metaDataBinding.doAddConfiguration(conf);
            Iterator it = compassMetaData.groupsIterator();
            while (it.hasNext()) {
                DefaultMetaDataGroup group = (DefaultMetaDataGroup)it.next();
                String className = group.getId();
                className = className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
                File javaFile = new File(this.destDir, files[i]);
                if (!javaFile.getParentFile().exists()) {
                    javaFile.mkdirs();
                }
                javaFile = new File(javaFile.getParentFile(), className + ".java");
                String packageName = "";
                File tmpFile = javaFile.getParentFile();
                while (!this.destDir.getAbsolutePath().equals(tmpFile.getAbsolutePath())) {
                    packageName = tmpFile.getName() + "." + packageName;
                    tmpFile = tmpFile.getParentFile();
                }
                packageName = packageName.substring(0, packageName.length() - 1);
                try {
                    System.out.println("Generating common meta data for [" + srcFile.getAbsolutePath() + "]");
                    PrintWriter writer = new PrintWriter(new OutputStreamWriter(new FileOutputStream(javaFile)));
                    PrintHelper printHelper = new PrintHelper(writer);
                    printHelper.print("// Auto generated by compass meta-data ant task at: " + new Date());
                    printHelper.print("package " + packageName + ";");
                    printHelper.emptyLine();
                    printHelper.printJavaDoc(group.getDescription());
                    printHelper.startClass(false, className);
                    printHelper.printJavaDoc(group.getDescription());
                    printHelper.startClass(true, "group");
                    printHelper.printConstant("Id", group.getId());
                    printHelper.printConstant("DispayName", group.getDisplayName());
                    printHelper.printConstant("Uri", group.getUri());
                    printHelper.endClass();
                    printHelper.startClass(true, "alias");
                    Iterator aliasIt = group.aliasIterator();
                    while (aliasIt.hasNext()) {
                        Alias alias = (Alias)aliasIt.next();
                        printHelper.printJavaDoc(alias.getDescription());
                        printHelper.startClass(true, alias.getId());
                        printHelper.printConstant("Id", alias.getId());
                        printHelper.printConstant("Name", alias.getName());
                        printHelper.printConstant("DisplayName", alias.getDisplayName());
                        printHelper.printConstant("Uri", alias.getUri());
                        printHelper.printConstant("GroupId", alias.getGroup().getId());
                        printHelper.endClass();
                    }
                    printHelper.endClass();
                    printHelper.startClass(true, "metaData");
                    Iterator metaDataIt = group.metaDataIterator();
                    while (metaDataIt.hasNext()) {
                        MetaData metaData = (MetaData)metaDataIt.next();
                        printHelper.printJavaDoc(metaData.getDescription());
                        printHelper.startClass(true, metaData.getId());
                        printHelper.printConstant("Id", metaData.getId());
                        printHelper.printConstant("Name", metaData.getName());
                        printHelper.printConstant("DisplayName", metaData.getDisplayName());
                        printHelper.printConstant("Uri", metaData.getUri());
                        printHelper.printConstant("GroupId", metaData.getGroup().getId());
                        if (metaData.getFormat() != null) {
                            printHelper.printConstant("Format", metaData.getFormat());
                        }
                        printHelper.endClass();
                    }
                    printHelper.endClass();
                    printHelper.endClass();
                    printHelper.close();
                }
                catch (FileNotFoundException e) {
                    throw new BuildException("Failed to write to file: " + javaFile.getAbsolutePath(), (Throwable)e);
                }
            }
        }
    }

    private static final class PrintHelper {
        private PrintWriter writer;
        private int indent = 0;

        public PrintHelper(PrintWriter writer) {
            this.writer = writer;
        }

        public void close() {
            this.writer.flush();
            this.writer.close();
        }

        public void emptyLine() {
            this.writer.println();
        }

        public void startClass(boolean isStatic, String className) {
            this.writeIndent();
            this.writer.print("public ");
            if (isStatic) {
                this.writer.print("static ");
            }
            className = className.substring(0, 1).toUpperCase() + className.substring(1, className.length());
            this.writer.print("final class " + className + " {");
            this.emptyLine();
            ++this.indent;
        }

        public void endClass() {
            --this.indent;
            this.writeIndent();
            this.writer.println("}");
            this.emptyLine();
        }

        public void print(String line) {
            this.writer.println(line);
        }

        public void printConstant(String name, String value) {
            this.printConstant("String", name, value);
        }

        public void printConstant(String type, String name, String value) {
            this.writeIndent();
            this.writer.print("public static final ");
            this.writer.print(type);
            this.writer.print(" ");
            this.writer.print(name);
            this.writer.print(" = ");
            this.writer.print("\"");
            this.writer.print(value);
            this.writer.print("\";");
            this.emptyLine();
        }

        public void printJavaDoc(String description) {
            this.writeIndent();
            this.writer.println("/**");
            this.writeIndent();
            this.writer.print(" * ");
            this.writer.println(description);
            this.writeIndent();
            this.writer.println(" */");
        }

        private void writeIndent() {
            for (int i = 0; i < this.indent; ++i) {
                this.writer.print("\t");
            }
        }
    }
}

