/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.transaction;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTransaction;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.transaction.AbstractTransaction;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionFactory;

public class LocalTransaction
extends AbstractTransaction {
    private static final Log log = LogFactory.getLog(LocalTransaction.class);
    private static final int UNKNOWN = -1;
    private static final int STARTED = 0;
    private static final int COMMIT = 1;
    private static final int ROLLBACK = 2;
    private int state = -1;
    private InternalCompassSession session;
    private InternalCompass compass;
    private CompassTransaction.TransactionIsolation transactionIsolation;

    public LocalTransaction(InternalCompassSession session, TransactionFactory transactionFactory, CompassTransaction.TransactionIsolation transactionIsolation) {
        super(transactionFactory);
        this.session = session;
        this.compass = session.getCompass();
        this.transactionIsolation = transactionIsolation;
    }

    public void join(InternalCompassSession session) throws CompassException {
        this.session = session;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Joining an existing local transcation on thread [" + Thread.currentThread().getName() + "] Compass [" + System.identityHashCode(this.compass) + "] Session [" + System.identityHashCode(session) + "]"));
        }
    }

    public void begin() throws CompassException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Starting a new local transcation on thread [" + Thread.currentThread().getName() + "] Compass [" + System.identityHashCode(this.compass) + "] Session [" + System.identityHashCode(this.session) + "]  with isolation [" + this.transactionIsolation + "]"));
        }
        this.session.getSearchEngine().begin(this.transactionIsolation);
        this.state = 0;
    }

    protected void doCommit() throws CompassException {
        if (this.session.getSearchEngine().wasRolledBack()) {
            // empty if block
        }
        if (this.state == -1) {
            log.debug((Object)("Not committing the transaction since within a local transaction on thread [" + Thread.currentThread().getName() + "] Compass [" + System.identityHashCode(this.compass) + "] Session [" + System.identityHashCode(this.session) + "]"));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Committing local transaction on thread [" + Thread.currentThread().getName() + "] Compass [" + System.identityHashCode(this.compass) + "] Session [" + System.identityHashCode(this.session) + "]"));
        }
        this.session.evictAll();
        ((LocalTransactionFactory)this.transactionFactory).unbindSessionFromTransaction(this, this.session);
        this.session.getSearchEngine().commit(true);
        this.state = 1;
    }

    protected void doRollback() throws CompassException {
        if (this.session.getSearchEngine().wasRolledBack()) {
            // empty if block
        }
        if (this.state == -1) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rolling back local transaction, which exists within another local transaction  on thread [" + Thread.currentThread().getName() + "] Compass [" + System.identityHashCode(this.compass) + "] Session [" + System.identityHashCode(this.session) + "]"));
            }
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Rolling back local transaction on thread [" + Thread.currentThread().getName() + "] Compass [" + System.identityHashCode(this.compass) + "] Session [" + System.identityHashCode(this.session) + "]"));
            }
            ((LocalTransactionFactory)this.transactionFactory).unbindSessionFromTransaction(this, this.session);
        }
        this.state = 2;
        this.session.evictAll();
        this.session.getSearchEngine().rollback();
    }

    public boolean wasRolledBack() throws CompassException {
        return this.session.getSearchEngine().wasRolledBack();
    }

    public boolean wasCommitted() throws CompassException {
        return this.session.getSearchEngine().wasCommitted();
    }

    public CompassSession getSession() {
        return this.session;
    }
}

