/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import org.compass.core.util.StringUtils;

public class FileHandlerMonitor {
    private File file;

    public FileHandlerMonitor(String filePath) {
        this.file = new File(filePath);
    }

    public FileHandlerMonitor(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileHandlers handlers() throws Exception {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase().startsWith("windows")) {
            throw new UnsupportedOperationException("File handlers not supported on windows");
        }
        String command = "lsof | grep " + this.file.getAbsolutePath();
        Process process = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        StringBuilder sb = new StringBuilder();
        try {
            int val = reader.read();
            while (val != -1) {
                sb.append((char)val);
                val = reader.read();
                try {
                    process.exitValue();
                    break;
                }
                catch (IllegalThreadStateException e) {
                }
            }
        }
        finally {
            try {
                process.getInputStream().close();
            }
            catch (Exception e1) {}
            try {
                process.getOutputStream().close();
            }
            catch (Exception e1) {}
            try {
                process.getErrorStream().close();
            }
            catch (Exception e1) {}
            process.destroy();
        }
        return new FileHandlers(sb.toString());
    }

    public static class FileHandlers {
        private String output;

        public FileHandlers(String output) {
            this.output = output;
        }

        public boolean hasHandlers() {
            return StringUtils.hasLength(this.output);
        }

        public String getRawOutput() {
            return this.output;
        }
    }
}

