/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.lucene.store.BufferedIndexOutput;
import org.compass.needle.coherence.CoherenceDirectory;
import org.compass.needle.coherence.FileBucketKey;
import org.compass.needle.coherence.FileBucketValue;
import org.compass.needle.coherence.FileHeaderKey;
import org.compass.needle.coherence.FileHeaderValue;

class CoherenceFileIndexOutput
extends BufferedIndexOutput {
    private CoherenceDirectory dir;
    private File tempFile;
    private RandomAccessFile file = null;
    private String fileName;
    private boolean isOpen;

    public CoherenceFileIndexOutput(CoherenceDirectory dir, String fileName) throws IOException {
        this.dir = dir;
        this.fileName = fileName;
        this.tempFile = File.createTempFile(dir.getIndexName() + "_" + fileName + "_" + System.currentTimeMillis(), ".lucene-coherencedir");
        this.file = new RandomAccessFile(this.tempFile, "rw");
        this.isOpen = true;
    }

    public void flushBuffer(byte[] b, int offset, int size) throws IOException {
        this.file.write(b, offset, size);
    }

    public void close() throws IOException {
        if (this.isOpen) {
            super.close();
            if (this.fileName.equals("segments.gen")) {
                this.dir.deleteFile(this.fileName);
            }
            this.file.seek(0L);
            byte[] buffer = new byte[this.dir.getBucketSize()];
            int offset = 0;
            int length = this.dir.getBucketSize();
            long bucketIndex = 0L;
            while (true) {
                int sizeRead;
                if ((sizeRead = this.file.read(buffer, offset, length)) == -1) break;
                offset += sizeRead;
                if ((length -= sizeRead) > 0) continue;
                this.flushBucket(bucketIndex++, buffer, this.dir.getBucketSize());
                offset = 0;
                length = this.dir.getBucketSize();
            }
            this.flushBucket(bucketIndex, buffer, offset);
            FileHeaderKey fileHeaderKey = new FileHeaderKey(this.dir.getIndexName(), this.fileName);
            FileHeaderValue fileHeaderValue = new FileHeaderValue(System.currentTimeMillis(), this.file.length());
            this.dir.getCache().put((Object)fileHeaderKey, (Object)fileHeaderValue);
            this.file.close();
            this.tempFile.delete();
            this.isOpen = false;
        }
    }

    public void seek(long pos) throws IOException {
        super.seek(pos);
        this.file.seek(pos);
    }

    public long length() throws IOException {
        return this.file.length();
    }

    private void flushBucket(long bucketIndex, byte[] buffer, int length) throws IOException {
        FileBucketKey fileBucketKey = new FileBucketKey(this.dir.getIndexName(), this.fileName, bucketIndex);
        byte[] data = new byte[length];
        System.arraycopy(buffer, 0, data, 0, length);
        FileBucketValue fileBucketValue = new FileBucketValue(data);
        this.dir.getCache().put((Object)fileBucketKey, (Object)fileBucketValue);
    }
}

