/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.coherence;

import com.tangosol.net.cache.CacheStore;
import com.tangosol.util.Base;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.compass.core.Compass;
import org.compass.core.CompassCallbackWithoutResult;
import org.compass.core.CompassException;
import org.compass.core.CompassSession;
import org.compass.core.CompassTemplate;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassConfigurationFactory;

public class CompassCacheStore
extends Base
implements CacheStore {
    private String entityName;
    private Compass compass;
    private CompassTemplate compassTemplate;

    public CompassCacheStore(String entityName) {
        this.entityName = entityName;
        CompassConfiguration configuration = CompassConfigurationFactory.newConfiguration();
        configuration.configure();
        this.compass = configuration.buildCompass();
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    public CompassCacheStore(String entityName, String resource) {
        this.entityName = entityName;
        CompassConfiguration configuration = CompassConfigurationFactory.newConfiguration();
        configuration.configure(resource);
        this.compass = configuration.buildCompass();
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    public CompassCacheStore(String entityName, File configurationFile) {
        this.entityName = entityName;
        CompassConfiguration configuration = CompassConfigurationFactory.newConfiguration();
        configuration.configure(configurationFile);
        this.compass = configuration.buildCompass();
        this.compassTemplate = new CompassTemplate(this.compass);
    }

    public Object load(Object o) {
        return null;
    }

    public Map loadAll(Collection collection) {
        return new HashMap();
    }

    public void store(Object key, Object value) {
        this.compassTemplate.save(this.entityName, value);
    }

    public void storeAll(final Map entries) {
        this.compassTemplate.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                Iterator it = entries.values().iterator();
                while (it.hasNext()) {
                    session.save(CompassCacheStore.this.entityName, it.next());
                }
            }
        });
    }

    public void erase(Object key) {
        this.compassTemplate.delete(this.entityName, key);
    }

    public void eraseAll(final Collection keys) {
        this.compassTemplate.execute(new CompassCallbackWithoutResult(){

            protected void doInCompassWithoutResult(CompassSession session) throws CompassException {
                Iterator it = keys.iterator();
                while (it.hasNext()) {
                    session.delete(CompassCacheStore.this.entityName, it.next());
                }
            }
        });
    }
}

