/*
 * Decompiled with CFR 0.152.
 */
package org.compass.needle.gigaspaces.store;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.store.IndexOutput;
import org.compass.needle.gigaspaces.store.FileBucketEntry;
import org.compass.needle.gigaspaces.store.FileEntry;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectory;
import org.compass.needle.gigaspaces.store.GigaSpaceDirectoryException;

class GigaSpaceMemIndexOutput
extends IndexOutput {
    private GigaSpaceDirectory dir;
    private String fileName;
    private FileBucketEntry firstBucketEntry;
    private byte[] buffer;
    private int bufferPosition;
    private int currentBucketIndex;
    private long length;
    private long position;
    private boolean open;
    private boolean seekOccured;
    private ArrayList<FileBucketEntry> flushBuckets;

    public GigaSpaceMemIndexOutput(GigaSpaceDirectory dir, String fileName) throws IOException {
        this.dir = dir;
        this.fileName = fileName;
        this.open = true;
        this.buffer = new byte[dir.getBucketSize()];
        if (fileName.equals("segments.gen")) {
            dir.deleteFile(fileName);
        }
        this.flushBuckets = new ArrayList(dir.getFlushRate());
    }

    public void writeByte(byte b) throws IOException {
        if (this.bufferPosition == this.dir.getBucketSize()) {
            if (this.seekOccured) {
                throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "Seek occured and overflowed first bucket");
            }
            this.flushBucket();
        }
        this.buffer[this.bufferPosition++] = b;
        if (!this.seekOccured) {
            ++this.length;
            ++this.position;
        }
    }

    public void writeBytes(byte[] b, int offset, int len) throws IOException {
        if (!this.seekOccured) {
            this.position += (long)len;
            this.length += (long)len;
        }
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition == this.dir.getBucketSize()) {
                if (this.seekOccured) {
                    throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "Seek occured and overflowed first bucket");
                }
                this.flushBucket();
            }
            int bytesToCopy = len < (remainInBuffer = this.dir.getBucketSize() - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(b, offset, this.buffer, this.bufferPosition, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    public void flush() throws IOException {
    }

    public void close() throws IOException {
        if (!this.open) {
            return;
        }
        this.open = false;
        this.flushBucket();
        this.forceFlushBuckets(this.firstBucketEntry, new FileEntry(this.dir.getIndexName(), this.fileName, this.length));
        this.buffer = null;
        this.firstBucketEntry = null;
    }

    public long getFilePointer() {
        return this.position;
    }

    public void seek(long pos) throws IOException {
        if (pos >= (long)this.dir.getBucketSize()) {
            throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "seek called outside of first bucket boundries");
        }
        if (this.firstBucketEntry == null) {
            this.firstBucketEntry = new FileBucketEntry(this.dir.getIndexName(), this.fileName, 0L, new byte[this.bufferPosition]);
            System.arraycopy(this.buffer, 0, this.firstBucketEntry.data, 0, this.bufferPosition);
        } else if (!this.seekOccured) {
            this.flushBucket(this.currentBucketIndex, this.buffer, this.bufferPosition);
        }
        this.position = pos;
        this.currentBucketIndex = 0;
        this.bufferPosition = (int)pos;
        this.buffer = this.firstBucketEntry.data;
        this.seekOccured = true;
    }

    public long length() throws IOException {
        return this.length;
    }

    private void flushBucket() throws IOException {
        if (this.currentBucketIndex == 0) {
            if (this.firstBucketEntry == null) {
                this.firstBucketEntry = new FileBucketEntry(this.dir.getIndexName(), this.fileName, 0L, new byte[this.bufferPosition]);
                System.arraycopy(this.buffer, 0, this.firstBucketEntry.data, 0, this.bufferPosition);
            }
        } else if (this.bufferPosition > 0) {
            this.flushBucket(this.currentBucketIndex, this.buffer, this.bufferPosition);
        }
        ++this.currentBucketIndex;
        this.bufferPosition = 0;
    }

    private void flushBucket(long bucketIndex, byte[] buffer, int length) throws IOException {
        FileBucketEntry fileBucketEntry = new FileBucketEntry(this.dir.getIndexName(), this.fileName, bucketIndex, null);
        fileBucketEntry.data = new byte[length];
        System.arraycopy(buffer, 0, fileBucketEntry.data, 0, length);
        this.flushBuckets.add(fileBucketEntry);
        if (this.flushBuckets.size() >= this.dir.getFlushRate()) {
            this.forceFlushBuckets(new Object[0]);
        }
    }

    private void forceFlushBuckets(Object ... additionalEntries) throws IOException {
        if (this.flushBuckets.size() == 0 && additionalEntries == null) {
            return;
        }
        Object[] entries = new Object[this.flushBuckets.size() + additionalEntries.length];
        this.flushBuckets.toArray(entries);
        for (int i = 0; i < additionalEntries.length; ++i) {
            entries[this.flushBuckets.size() + i] = additionalEntries[i];
        }
        try {
            this.dir.getSpace().writeMultiple(entries, null, Long.MAX_VALUE);
        }
        catch (Exception e) {
            throw new GigaSpaceDirectoryException(this.dir.getIndexName(), this.fileName, "Failed to write buckets", e);
        }
        finally {
            this.flushBuckets.clear();
        }
    }
}

