/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import com.google.gson.JsonParser;
import com.sun.phobos.script.javascript.RhinoScriptEngineFactory;
import com.sun.script.groovy.GroovyScriptEngineFactory;
import com.sun.script.jruby.JRubyScriptEngineFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import javax.activation.DataHandler;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMText;
import org.apache.bsf.xml.XMLHelper;
import org.apache.commons.io.IOUtils;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.bsf.ScriptMessageContext;

public class ScriptMediator
extends AbstractMediator {
    private static final String MC_VAR_NAME = "mc";
    private Value key;
    private String language;
    private final Map<Value, Object> includes;
    private String function = "mediate";
    private String scriptSourceCode;
    protected ScriptEngine scriptEngine;
    private boolean multiThreadedEngine;
    private CompiledScript compiledScript;
    private Invocable invocableScript;
    private XMLHelper xmlHelper;
    private final Object resourceLock = new Object();
    private JsonParser jsonParser;

    public ScriptMediator(String language, String scriptSourceCode) {
        this.language = language;
        this.scriptSourceCode = scriptSourceCode;
        this.includes = new TreeMap<Value, Object>();
        this.initInlineScript();
    }

    public ScriptMediator(String language, Map<Value, Object> includeKeysMap, Value key, String function) {
        this.language = language;
        this.key = key;
        this.includes = includeKeysMap;
        if (function != null) {
            this.function = function;
        }
        this.initScriptEngine();
        if (!(this.scriptEngine instanceof Invocable)) {
            throw new SynapseException("Script engine is not an Invocable engine for language: " + language);
        }
        this.invocableScript = (Invocable)((Object)this.scriptEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mediate(MessageContext synCtx) {
        boolean returnValue;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Script mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Scripting language : " + this.language + " source " + (this.key == null ? ": specified inline " : " loaded with key : " + this.key) + (this.function != null ? " function : " + this.function : "")));
        }
        if (this.multiThreadedEngine) {
            returnValue = this.invokeScript(synCtx);
        } else {
            Class<?> clazz = this.scriptEngine.getClass();
            synchronized (clazz) {
                returnValue = this.invokeScript(synCtx);
            }
        }
        if (synLog.isTraceTraceEnabled()) {
            synLog.traceTrace((Object)("Result message after execution of script : " + synCtx.getEnvelope()));
        }
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("End : Script mediator return value : " + returnValue));
        }
        return returnValue;
    }

    private boolean invokeScript(MessageContext synCtx) {
        boolean returnValue;
        try {
            Object returnObject = this.key != null ? this.mediateWithExternalScript(synCtx) : this.mediateForInlineScript(synCtx);
            returnValue = returnObject == null || !(returnObject instanceof Boolean) || (Boolean)returnObject != false;
        }
        catch (ScriptException e) {
            this.handleException("The script engine returned an error executing the " + (this.key == null ? "inlined " : "external ") + this.language + " script" + (this.key != null ? " : " + this.key : "") + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        catch (NoSuchMethodException e) {
            this.handleException("The script engine returned a NoSuchMethodException executing the external " + this.language + " script" + " : " + this.key + (this.function != null ? " function " + this.function : ""), e, synCtx);
            returnValue = false;
        }
        return returnValue;
    }

    private Object mediateWithExternalScript(MessageContext synCtx) throws ScriptException, NoSuchMethodException {
        this.prepareExternalScript(synCtx);
        ScriptMessageContext scriptMC = new ScriptMessageContext(synCtx, this.xmlHelper);
        this.processJSONPayload(synCtx, scriptMC);
        return this.invocableScript.invokeFunction(this.function, scriptMC);
    }

    private Object mediateForInlineScript(MessageContext synCtx) throws ScriptException {
        ScriptMessageContext scriptMC = new ScriptMessageContext(synCtx, this.xmlHelper);
        this.processJSONPayload(synCtx, scriptMC);
        Bindings bindings = this.scriptEngine.createBindings();
        bindings.put(MC_VAR_NAME, (Object)scriptMC);
        Object response = this.compiledScript != null ? this.compiledScript.eval(bindings) : this.scriptEngine.eval(this.scriptSourceCode, bindings);
        return response;
    }

    private void processJSONPayload(MessageContext synCtx, ScriptMessageContext scriptMC) throws ScriptException {
        if (!(synCtx instanceof Axis2MessageContext)) {
            return;
        }
        org.apache.axis2.context.MessageContext messageContext = ((Axis2MessageContext)synCtx).getAxis2MessageContext();
        String contentType = (String)messageContext.getProperty("messageType");
        if ("application/json".equals(contentType)) {
            String jsonString = (String)messageContext.getProperty("JSON_STRING");
            InputStream jsonStream = (InputStream)messageContext.getProperty("JSON_STREAM");
            String jsonPayload = "{}";
            this.prepareForJSON(scriptMC);
            if (jsonString != null) {
                jsonPayload = this.jsonParser.parse(jsonString).toString();
            } else if (jsonStream != null) {
                try {
                    jsonString = IOUtils.toString((InputStream)jsonStream, (String)((String)messageContext.getProperty("CHARACTER_SET_ENCODING")));
                    jsonPayload = this.jsonParser.parse(jsonString).toString();
                }
                catch (IOException e) {
                    this.handleException("Failed to get the JSON payload string from the input stream.");
                }
                messageContext.setProperty("JSON_STRING", (Object)jsonPayload);
            }
            Object jsonObject = this.scriptEngine.eval('(' + jsonPayload + ')');
            synCtx.setProperty("JSON_OBJECT", jsonObject);
        }
    }

    private void prepareForJSON(ScriptMessageContext scriptMC) {
        if (this.jsonParser == null) {
            this.jsonParser = new JsonParser();
        }
        scriptMC.setScriptEngine(this.scriptEngine);
    }

    protected void initInlineScript() {
        try {
            this.initScriptEngine();
            if (this.scriptEngine instanceof Compilable) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Script engine supports Compilable interface, compiling script code..");
                }
                this.compiledScript = ((Compilable)((Object)this.scriptEngine)).compile(this.scriptSourceCode);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Script engine does not support the Compilable interface, in-lined script would be evaluated on each invocation..");
            }
        }
        catch (ScriptException e) {
            throw new SynapseException("Exception initializing inline script", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void prepareExternalScript(MessageContext synCtx) throws ScriptException {
        String generatedScriptKey = this.key.evaluateValue(synCtx);
        Entry entry = synCtx.getConfiguration().getEntryDefinition(generatedScriptKey);
        boolean needsReload = entry != null && entry.isDynamic() && (!entry.isCached() || entry.isExpired());
        Object object = this.resourceLock;
        synchronized (object) {
            if (this.scriptSourceCode == null || needsReload) {
                DataHandler dataHandler;
                Object o = synCtx.getEntry(generatedScriptKey);
                if (o instanceof OMElement) {
                    this.scriptSourceCode = ((OMElement)o).getText();
                    this.scriptEngine.eval(this.scriptSourceCode);
                } else if (o instanceof String) {
                    this.scriptSourceCode = (String)o;
                    this.scriptEngine.eval(this.scriptSourceCode);
                } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                    BufferedReader reader = null;
                    try {
                        reader = new BufferedReader(new InputStreamReader(dataHandler.getInputStream()));
                        this.scriptEngine.eval(reader);
                    }
                    catch (IOException e) {
                        this.handleException("Error in reading script as a stream ", e, synCtx);
                    }
                    finally {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException e) {
                                this.handleException("Error in closing input stream ", e, synCtx);
                            }
                        }
                    }
                }
            }
        }
        for (Value includeKey : this.includes.keySet()) {
            String includeSourceCode = (String)this.includes.get(includeKey);
            String generatedKey = includeKey.evaluateValue(synCtx);
            Entry includeEntry = synCtx.getConfiguration().getEntryDefinition(generatedKey);
            boolean includeEntryNeedsReload = includeEntry != null && includeEntry.isDynamic() && (!includeEntry.isCached() || includeEntry.isExpired());
            Object object2 = this.resourceLock;
            synchronized (object2) {
                if (includeSourceCode == null || includeEntryNeedsReload) {
                    DataHandler dataHandler;
                    this.log.debug((Object)("Re-/Loading the include script with key " + includeKey));
                    Object o = synCtx.getEntry(generatedKey);
                    if (o instanceof OMElement) {
                        includeSourceCode = ((OMElement)o).getText();
                        this.scriptEngine.eval(includeSourceCode);
                    } else if (o instanceof String) {
                        includeSourceCode = (String)o;
                        this.scriptEngine.eval(includeSourceCode);
                    } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                        BufferedReader reader = null;
                        try {
                            reader = new BufferedReader(new InputStreamReader(dataHandler.getInputStream()));
                            this.scriptEngine.eval(reader);
                        }
                        catch (IOException e) {
                            this.handleException("Error in reading script as a stream ", e, synCtx);
                        }
                        finally {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (IOException e) {
                                    this.handleException("Error in closing input stream ", e, synCtx);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    protected void initScriptEngine() {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Initializing script mediator for language : " + this.language));
        }
        ScriptEngineManager manager = new ScriptEngineManager();
        manager.registerEngineExtension("js", (ScriptEngineFactory)new RhinoScriptEngineFactory());
        manager.registerEngineExtension("groovy", (ScriptEngineFactory)new GroovyScriptEngineFactory());
        manager.registerEngineExtension("rb", (ScriptEngineFactory)new JRubyScriptEngineFactory());
        this.scriptEngine = manager.getEngineByExtension(this.language);
        if (this.scriptEngine == null) {
            this.handleException("No script engine found for language: " + this.language);
        }
        this.xmlHelper = XMLHelper.getArgHelper((ScriptEngine)this.scriptEngine);
        this.multiThreadedEngine = this.scriptEngine.getFactory().getParameter("THREADING") != null;
        this.log.debug((Object)("Script mediator for language : " + this.language + " supports multithreading? : " + this.multiThreadedEngine));
    }

    public String getLanguage() {
        return this.language;
    }

    public Value getKey() {
        return this.key;
    }

    public String getFunction() {
        return this.function;
    }

    public String getScriptSrc() {
        return this.scriptSourceCode;
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Map<Value, Object> getIncludeMap() {
        return this.includes;
    }
}

