/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.bsf;

import java.io.StringWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.bsf.xml.XMLHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.FaultHandler;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.config.SynapseConfiguration;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.core.axis2.Axis2MessageContext;
import org.apache.synapse.endpoints.Endpoint;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.Wrapper;
import org.mozilla.javascript.xml.XMLObject;

public class ScriptMessageContext
implements MessageContext {
    private final MessageContext mc;
    private final XMLHelper xmlHelper;
    private ScriptEngine scriptEngine;

    public ScriptMessageContext(MessageContext mc, XMLHelper xmlHelper) {
        this.mc = mc;
        this.xmlHelper = xmlHelper;
    }

    public Object getPayloadXML() throws ScriptException {
        return this.xmlHelper.toScriptXML(this.mc.getEnvelope().getBody().getFirstElement());
    }

    public void setPayloadXML(Object payload) throws OMException, ScriptException {
        SOAPBody body = this.mc.getEnvelope().getBody();
        OMElement firstChild = body.getFirstElement();
        OMElement omElement = this.xmlHelper.toOMElement(payload);
        if (firstChild == null) {
            body.addChild((OMNode)omElement);
        } else {
            firstChild.insertSiblingAfter((OMNode)omElement);
            firstChild.detach();
        }
    }

    public Object getPayloadJSON() {
        return this.mc.getProperty("JSON_OBJECT");
    }

    public void setPayloadJSON(Object jsonPayload) throws ScriptException {
        org.apache.axis2.context.MessageContext messageContext = ((Axis2MessageContext)this.mc).getAxis2MessageContext();
        String jsonString = this.serializeJSON(jsonPayload);
        messageContext.setProperty("JSON_STRING", (Object)jsonString);
        Object jsonObject = this.scriptEngine.eval('(' + jsonString + ')');
        this.mc.setProperty("JSON_OBJECT", jsonObject);
    }

    public void setScriptEngine(ScriptEngine scriptEngine) {
        this.scriptEngine = scriptEngine;
    }

    public void addHeader(boolean mustUnderstand, Object content) throws ScriptException {
        SOAPEnvelope envelope = this.mc.getEnvelope();
        SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            header = factory.createSOAPHeader(envelope);
        }
        OMElement element = this.xmlHelper.toOMElement(content);
        SOAPHeaderBlock headerBlock = header.addHeaderBlock(element.getLocalName(), element.getNamespace());
        Iterator it = element.getAllAttributes();
        while (it.hasNext()) {
            headerBlock.addAttribute((OMAttribute)it.next());
        }
        headerBlock.setMustUnderstand(mustUnderstand);
        OMNode child = element.getFirstOMChild();
        while (child != null) {
            OMNode next = child.getNextOMSibling();
            headerBlock.addChild(child);
            child = next;
        }
    }

    public Object getEnvelopeXML() throws ScriptException {
        return this.xmlHelper.toScriptXML((OMElement)this.mc.getEnvelope());
    }

    public void setTo(String reference) {
        this.mc.setTo(new EndpointReference(reference));
    }

    public void setFaultTo(String reference) {
        this.mc.setFaultTo(new EndpointReference(reference));
    }

    public void setFrom(String reference) {
        this.mc.setFrom(new EndpointReference(reference));
    }

    public void setReplyTo(String reference) {
        this.mc.setReplyTo(new EndpointReference(reference));
    }

    public SynapseConfiguration getConfiguration() {
        return this.mc.getConfiguration();
    }

    public void setConfiguration(SynapseConfiguration cfg) {
        this.mc.setConfiguration(cfg);
    }

    public SynapseEnvironment getEnvironment() {
        return this.mc.getEnvironment();
    }

    public void setEnvironment(SynapseEnvironment se) {
        this.mc.setEnvironment(se);
    }

    public Map<String, Object> getContextEntries() {
        return this.mc.getContextEntries();
    }

    public void setContextEntries(Map<String, Object> entries) {
        this.mc.setContextEntries(entries);
    }

    public Object getProperty(String key) {
        return this.mc.getProperty(key);
    }

    public Object getEntry(String key) {
        return this.mc.getEntry(key);
    }

    public void setProperty(String key, Object value) {
        if (value instanceof XMLObject) {
            OMElement omElement = null;
            try {
                omElement = this.xmlHelper.toOMElement(value);
            }
            catch (ScriptException e) {
                this.mc.setProperty(key, value);
            }
            if (omElement != null) {
                this.mc.setProperty(key, (Object)omElement);
            }
        } else {
            this.mc.setProperty(key, value);
        }
    }

    public Set getPropertyKeySet() {
        return this.mc.getPropertyKeySet();
    }

    public Mediator getMainSequence() {
        return this.mc.getMainSequence();
    }

    public Mediator getFaultSequence() {
        return this.mc.getFaultSequence();
    }

    public Mediator getSequence(String key) {
        return this.mc.getSequence(key);
    }

    public OMElement getFormat(String s) {
        return null;
    }

    public Endpoint getEndpoint(String key) {
        return this.mc.getEndpoint(key);
    }

    public SOAPEnvelope getEnvelope() {
        return this.mc.getEnvelope();
    }

    public void setEnvelope(SOAPEnvelope envelope) throws AxisFault {
        this.mc.setEnvelope(envelope);
    }

    public EndpointReference getFaultTo() {
        return this.mc.getFaultTo();
    }

    public void setFaultTo(EndpointReference reference) {
        this.mc.setFaultTo(reference);
    }

    public EndpointReference getFrom() {
        return this.mc.getFrom();
    }

    public void setFrom(EndpointReference reference) {
        this.mc.setFrom(reference);
    }

    public String getMessageID() {
        return this.mc.getMessageID();
    }

    public void setMessageID(String string) {
        this.mc.setMessageID(string);
    }

    public RelatesTo getRelatesTo() {
        return this.mc.getRelatesTo();
    }

    public void setRelatesTo(RelatesTo[] reference) {
        this.mc.setRelatesTo(reference);
    }

    public EndpointReference getReplyTo() {
        return this.mc.getReplyTo();
    }

    public void setReplyTo(EndpointReference reference) {
        this.mc.setReplyTo(reference);
    }

    public EndpointReference getTo() {
        return this.mc.getTo();
    }

    public void setTo(EndpointReference reference) {
        this.mc.setTo(reference);
    }

    public void setWSAAction(String actionURI) {
        this.mc.setWSAAction(actionURI);
    }

    public String getWSAAction() {
        return this.mc.getWSAAction();
    }

    public String getSoapAction() {
        return this.mc.getSoapAction();
    }

    public void setSoapAction(String string) {
        this.mc.setSoapAction(string);
    }

    public void setWSAMessageID(String messageID) {
        this.mc.setWSAMessageID(messageID);
    }

    public String getWSAMessageID() {
        return this.mc.getWSAMessageID();
    }

    public boolean isDoingMTOM() {
        return this.mc.isDoingMTOM();
    }

    public boolean isDoingSWA() {
        return this.mc.isDoingSWA();
    }

    public void setDoingMTOM(boolean b) {
        this.mc.setDoingMTOM(b);
    }

    public void setDoingSWA(boolean b) {
        this.mc.setDoingSWA(b);
    }

    public boolean isDoingPOX() {
        return this.mc.isDoingPOX();
    }

    public void setDoingPOX(boolean b) {
        this.mc.setDoingPOX(b);
    }

    public boolean isDoingGET() {
        return this.mc.isDoingGET();
    }

    public void setDoingGET(boolean b) {
        this.mc.setDoingGET(b);
    }

    public boolean isSOAP11() {
        return this.mc.isSOAP11();
    }

    public void setResponse(boolean b) {
        this.mc.setResponse(b);
    }

    public boolean isResponse() {
        return this.mc.isResponse();
    }

    public void setFaultResponse(boolean b) {
        this.mc.setFaultResponse(b);
    }

    public boolean isFaultResponse() {
        return this.mc.isFaultResponse();
    }

    public int getTracingState() {
        return this.mc.getTracingState();
    }

    public void setTracingState(int tracingState) {
        this.mc.setTracingState(tracingState);
    }

    public Stack<FaultHandler> getFaultStack() {
        return this.mc.getFaultStack();
    }

    public void pushFaultHandler(FaultHandler fault) {
        this.mc.pushFaultHandler(fault);
    }

    public Log getServiceLog() {
        return LogFactory.getLog(ScriptMessageContext.class);
    }

    public Mediator getSequenceTemplate(String key) {
        return this.mc.getSequenceTemplate(key);
    }

    private String serializeJSON(Object obj) {
        StringWriter json = new StringWriter();
        if (obj instanceof Wrapper) {
            obj = ((Wrapper)obj).unwrap();
        }
        if (obj instanceof NativeObject) {
            json.append("{");
            NativeObject o = (NativeObject)obj;
            Object[] ids = o.getIds();
            boolean first = true;
            for (Object id : ids) {
                String key = (String)id;
                Object value = o.get((String)id, (Scriptable)o);
                if (!first) {
                    json.append(", ");
                } else {
                    first = false;
                }
                json.append("\"").append(key).append("\" : ").append(this.serializeJSON(value));
            }
            json.append("}");
        } else if (obj instanceof NativeArray) {
            json.append("[");
            NativeArray o = (NativeArray)obj;
            Object[] ids = o.getIds();
            boolean first = true;
            for (Object id : ids) {
                Object value = o.get(((Integer)id).intValue(), (Scriptable)o);
                if (!first) {
                    json.append(", ");
                } else {
                    first = false;
                }
                json.append(this.serializeJSON(value));
            }
            json.append("]");
        } else if (obj instanceof Object[]) {
            json.append("[");
            boolean first = true;
            for (Object value : (Object[])obj) {
                if (!first) {
                    json.append(", ");
                } else {
                    first = false;
                }
                json.append(this.serializeJSON(value));
            }
            json.append("]");
        } else if (obj instanceof String) {
            json.append("\"").append(obj.toString()).append("\"");
        } else if (obj instanceof Integer || obj instanceof Long || obj instanceof Float || obj instanceof Double || obj instanceof Short || obj instanceof BigInteger || obj instanceof BigDecimal || obj instanceof Boolean) {
            json.append(obj.toString());
        } else {
            json.append("{}");
        }
        return json.toString();
    }
}

