/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.spring;

import org.apache.synapse.ManagedLifecycle;
import org.apache.synapse.Mediator;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.Entry;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.core.SynapseEnvironment;
import org.apache.synapse.mediators.AbstractMediator;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class SpringMediator
extends AbstractMediator
implements ManagedLifecycle {
    private String beanName = null;
    private String configKey = null;
    private ApplicationContext appContext = null;

    public boolean mediate(MessageContext synCtx) {
        Entry entry;
        SynapseLog synLog = this.getLog(synCtx);
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)"Start : Spring mediator");
            if (synLog.isTraceTraceEnabled()) {
                synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
            }
        }
        if ((entry = synCtx.getConfiguration().getEntryDefinition(this.configKey)) != null && entry.isDynamic()) {
            if (!entry.isCached() || entry.isExpired()) {
                this.buildAppContext(synCtx, synLog);
            }
        } else if (this.appContext == null) {
            this.buildAppContext(synCtx, synLog);
        }
        if (this.appContext != null) {
            try {
                Object o = this.appContext.getBean(this.beanName);
                if (o != null && Mediator.class.isAssignableFrom(o.getClass())) {
                    Mediator m = (Mediator)o;
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("Loaded mediator from bean : " + this.beanName + " executing..."));
                    }
                    return m.mediate(synCtx);
                }
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Unable to load mediator from bean : " + this.beanName));
                }
                this.handleException("Could not load bean named : " + this.beanName + " from the Spring configuration with key : " + this.configKey, synCtx);
            }
            catch (Exception e) {
                this.handleException("No bean named '" + this.beanName + "' is defined", synCtx);
            }
        } else {
            this.handleException("Cannot reference application context with key : " + this.configKey, synCtx);
        }
        synLog.traceOrDebug((Object)"End : Spring mediator");
        return true;
    }

    private synchronized void buildAppContext(MessageContext synCtx, SynapseLog synLog) {
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Creating Spring ApplicationContext from key : " + this.configKey));
        }
        GenericApplicationContext appContext = new GenericApplicationContext();
        XmlBeanDefinitionReader xbdr = new XmlBeanDefinitionReader((BeanDefinitionRegistry)appContext);
        xbdr.setValidating(false);
        Object springConfig = synCtx.getEntry(this.configKey);
        if (springConfig == null) {
            String errorMessage = "Cannot look up Spring configuration " + this.configKey;
            this.log.error((Object)errorMessage);
            return;
        }
        xbdr.loadBeanDefinitions((Resource)new InputStreamResource(SynapseConfigUtils.getStreamSource((Object)springConfig).getInputStream()));
        appContext.refresh();
        if (synLog.isTraceOrDebugEnabled()) {
            synLog.traceOrDebug((Object)("Spring ApplicationContext from key : " + this.configKey + " created"));
        }
        this.appContext = appContext;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String getConfigKey() {
        return this.configKey;
    }

    public void setConfigKey(String configKey) {
        this.configKey = configKey;
    }

    public ApplicationContext getAppContext() {
        return this.appContext;
    }

    public void setAppContext(ApplicationContext appContext) {
        this.appContext = appContext;
    }

    public void init(SynapseEnvironment se) {
        MessageContext synCtx = se.createMessageContext();
        this.buildAppContext(synCtx, this.getLog(synCtx));
    }

    public void destroy() {
    }
}

