/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.config.Entry;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.jaxen.JaxenException;

public class MediatorCustomVariable
extends MediatorVariable {
    private static final Log log = LogFactory.getLog(MediatorCustomVariable.class);
    private String regKey;
    private SynapseXPath expression;
    private final Object resourceLock = new Object();

    public MediatorCustomVariable(QName name) {
        super(name);
        try {
            this.expression = new SynapseXPath("s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]");
            this.expression.addNamespace("s11", "http://schemas.xmlsoap.org/soap/envelope/");
            this.expression.addNamespace("s12", "http://www.w3.org/2003/05/soap-envelope");
        }
        catch (JaxenException e) {
            this.handleException("Error creating source XPath expression", (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean evaluateValue(MessageContext synCtx) {
        if (this.regKey == null) {
            this.value = this.evaluate(synCtx);
            return true;
        }
        boolean reLoad = false;
        boolean hasValueChanged = false;
        Entry dp = synCtx.getConfiguration().getEntryDefinition(this.regKey);
        if (dp != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired())) {
            reLoad = true;
        }
        Object object = this.resourceLock;
        synchronized (object) {
            if (reLoad || this.value == null) {
                hasValueChanged = true;
                Object o = synCtx.getEntry(this.regKey);
                if (o != null) {
                    this.value = !"s11:Body/child::*[position()=1] | s12:Body/child::*[position()=1]".equals(this.expression.toString()) ? this.evaluate(o) : o;
                }
            }
        }
        return hasValueChanged;
    }

    private Object evaluate(Object source) {
        try {
            Object result = this.expression.evaluate(source);
            if (result instanceof List && !((List)result).isEmpty()) {
                result = ((List)result).get(0);
            }
            if (result instanceof OMNode) {
                if (this.getType() != 4 && this.getType() != 5 && this.getType() != 7) {
                    int nodeType = ((OMNode)result).getType();
                    if (nodeType == 4) {
                        return ((OMText)result).getText();
                    }
                    if (nodeType == 1) {
                        return ((OMElement)result).getText();
                    }
                }
                return result;
            }
            return result;
        }
        catch (JaxenException e) {
            this.handleException("Error evaluating XPath " + this.expression + " on message" + source);
            return null;
        }
    }

    private void handleException(String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public void setExpression(SynapseXPath expression) {
        this.expression = expression;
    }

    public void setRegKey(String regKey) {
        this.regKey = regKey;
    }

    public String getRegKey() {
        return this.regKey;
    }

    public SynapseXPath getExpression() {
        return this.expression;
    }
}

