/*
 * Decompiled with CFR 0.152.
 */
package org.apache.synapse.mediators.xquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xquery.XQConnection;
import javax.xml.xquery.XQDataSource;
import javax.xml.xquery.XQDynamicContext;
import javax.xml.xquery.XQException;
import javax.xml.xquery.XQItem;
import javax.xml.xquery.XQItemType;
import javax.xml.xquery.XQPreparedExpression;
import javax.xml.xquery.XQResultSequence;
import net.sf.saxon.xqj.SaxonXQDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axiom.om.util.ElementHelper;
import org.apache.synapse.MessageContext;
import org.apache.synapse.SynapseException;
import org.apache.synapse.SynapseLog;
import org.apache.synapse.config.SynapseConfigUtils;
import org.apache.synapse.mediators.AbstractMediator;
import org.apache.synapse.mediators.MediatorProperty;
import org.apache.synapse.mediators.Value;
import org.apache.synapse.mediators.xquery.MediatorVariable;
import org.apache.synapse.util.xpath.SourceXPathSupport;
import org.apache.synapse.util.xpath.SynapseXPath;
import org.w3c.dom.Element;

public class XQueryMediator
extends AbstractMediator {
    private final List<MediatorProperty> dataSourceProperties = new ArrayList<MediatorProperty>();
    private Value queryKey;
    private String querySource;
    private final SourceXPathSupport target = new SourceXPathSupport();
    private final List<MediatorVariable> variables = new ArrayList<MediatorVariable>();
    private final Object resourceLock = new Object();
    private boolean useDOMSource = false;
    private XQDataSource cachedXQDataSource = null;
    private XQConnection cachedConnection = null;
    private Map<String, XQPreparedExpression> cachedPreparedExpressionMap = new Hashtable<String, XQPreparedExpression>();

    public boolean mediate(MessageContext synCtx) {
        try {
            SynapseLog synLog = this.getLog(synCtx);
            if (synLog.isTraceOrDebugEnabled()) {
                synLog.traceOrDebug((Object)"Start : XQuery mediator");
                if (synLog.isTraceTraceEnabled()) {
                    synLog.traceTrace((Object)("Message : " + synCtx.getEnvelope()));
                }
                synLog.traceOrDebug((Object)("Performing XQuery using query resource with key : " + this.queryKey));
            }
            this.performQuery(synCtx, synLog);
            synLog.traceOrDebug((Object)"End : XQuery mediator");
            return true;
        }
        catch (Exception e) {
            this.handleException("Unable to execute the query ", e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performQuery(MessageContext synCtx, SynapseLog synLog) {
        Object dp;
        boolean reLoad = false;
        boolean needBind = false;
        String generatedQueryKey = null;
        boolean isQueryKeyGenerated = false;
        if (this.queryKey != null) {
            generatedQueryKey = this.queryKey.evaluateValue(synCtx);
        }
        if (generatedQueryKey != null) {
            isQueryKeyGenerated = true;
        }
        XQPreparedExpression cachedPreparedExpression = null;
        if (generatedQueryKey != null && !"".equals(generatedQueryKey) && (dp = synCtx.getConfiguration().getEntryDefinition(generatedQueryKey)) != null && dp.isDynamic() && (!dp.isCached() || dp.isExpired())) {
            reLoad = true;
        }
        try {
            XQResultSequence resultSequence;
            dp = this.resourceLock;
            synchronized (dp) {
                if (this.cachedXQDataSource == null) {
                    this.cachedXQDataSource = new SaxonXQDataSource();
                    if (this.dataSourceProperties != null && !this.dataSourceProperties.isEmpty()) {
                        synLog.traceOrDebug((Object)"Setting up properties to the XQDataSource");
                        for (MediatorProperty dataSourceProperty : this.dataSourceProperties) {
                            if (dataSourceProperty == null) continue;
                            this.cachedXQDataSource.setProperty(dataSourceProperty.getName(), dataSourceProperty.getValue());
                        }
                    }
                }
                if (this.cachedConnection == null || this.cachedConnection != null && this.cachedConnection.isClosed()) {
                    synLog.traceOrDebug((Object)"Creating a connection from the XQDataSource ");
                    this.cachedConnection = this.cachedXQDataSource.getConnection();
                }
                if (isQueryKeyGenerated) {
                    cachedPreparedExpression = this.cachedPreparedExpressionMap.get(generatedQueryKey);
                }
                if (reLoad || cachedPreparedExpression == null || cachedPreparedExpression != null && cachedPreparedExpression.isClosed()) {
                    if (this.querySource != null && !"".equals(this.querySource)) {
                        if (cachedPreparedExpression == null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug((Object)("Using in-lined query source - " + this.querySource));
                                synLog.traceOrDebug((Object)"Prepare an expression for the query ");
                            }
                            cachedPreparedExpression = this.cachedConnection.prepareExpression(this.querySource);
                            if (isQueryKeyGenerated) {
                                this.cachedPreparedExpressionMap.put(generatedQueryKey, cachedPreparedExpression);
                            }
                            needBind = true;
                        }
                    } else {
                        DataHandler dataHandler;
                        Object o = synCtx.getEntry(generatedQueryKey);
                        if (o == null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug((Object)("Couldn't find the xquery source with a key " + this.queryKey));
                            }
                            throw new SynapseException("No object found for the key '" + generatedQueryKey + "'");
                        }
                        String sourceCode = null;
                        InputStream inputStream = null;
                        if (o instanceof OMElement) {
                            sourceCode = ((OMElement)o).getText();
                        } else if (o instanceof String) {
                            sourceCode = (String)o;
                        } else if (o instanceof OMText && (dataHandler = (DataHandler)((OMText)o).getDataHandler()) != null) {
                            try {
                                inputStream = dataHandler.getInputStream();
                                if (inputStream == null) {
                                    if (synLog.isTraceOrDebugEnabled()) {
                                        synLog.traceOrDebug((Object)("Couldn't get the stream from the xquery source with a key " + this.queryKey));
                                    }
                                    return;
                                }
                            }
                            catch (IOException e) {
                                this.handleException("Error in reading content as a stream ");
                            }
                        }
                        if ((sourceCode == null || "".equals(sourceCode)) && inputStream == null) {
                            if (synLog.isTraceOrDebugEnabled()) {
                                synLog.traceOrDebug((Object)("Couldn't find the xquery source with a key " + this.queryKey));
                            }
                            return;
                        }
                        if (synLog.isTraceOrDebugEnabled()) {
                            synLog.traceOrDebug((Object)("Picked up the xquery source from the key " + this.queryKey));
                            synLog.traceOrDebug((Object)"Prepare an expression for the query ");
                        }
                        cachedPreparedExpression = sourceCode != null ? this.cachedConnection.prepareExpression(sourceCode) : this.cachedConnection.prepareExpression(inputStream);
                        if (isQueryKeyGenerated) {
                            this.cachedPreparedExpressionMap.put(generatedQueryKey, cachedPreparedExpression);
                        }
                        needBind = true;
                    }
                }
                if (this.variables != null && !this.variables.isEmpty()) {
                    synLog.traceOrDebug((Object)"Binding  external variables to the DynamicContext");
                    for (MediatorVariable variable : this.variables) {
                        boolean hasValueChanged;
                        if (variable == null || !(hasValueChanged = variable.evaluateValue(synCtx)) && !needBind) continue;
                        this.bindVariable((XQDynamicContext)cachedPreparedExpression, variable, synLog);
                    }
                }
                resultSequence = cachedPreparedExpression.executeQuery();
            }
            if (resultSequence == null) {
                synLog.traceOrDebug((Object)"Result Sequence is null");
                return;
            }
            if (resultSequence.next()) {
                OMNode destination;
                XQItem xqItem = resultSequence.getItem();
                if (xqItem == null) {
                    return;
                }
                XQItemType itemType = xqItem.getItemType();
                if (itemType == null) {
                    return;
                }
                int itemKind = itemType.getItemKind();
                int baseType = itemType.getBaseType();
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("The XQuery Result " + xqItem.getItemAsString(null)));
                }
                if ((destination = this.target.selectOMNode(synCtx, synLog)) != null) {
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("The target node " + destination));
                    }
                    if (5 == itemKind || 7 == itemKind || 4 == itemKind) {
                        StAXOMBuilder builder = new StAXOMBuilder(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xqItem.getItemAsString(null))));
                        OMElement resultOM = builder.getDocumentElement();
                        if (resultOM != null) {
                            destination.insertSiblingAfter((OMNode)resultOM);
                            destination.detach();
                        }
                    } else if (13 == baseType || 12 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getInt()));
                    } else if (10 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getBoolean()));
                    } else if (18 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getDouble()));
                    } else if (20 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getFloat()));
                    } else if (15 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getLong()));
                    } else if (14 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getShort()));
                    } else if (31 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getByte()));
                    } else if (29 == baseType) {
                        ((OMElement)destination).setText(String.valueOf(xqItem.getItemAsString(null)));
                    }
                } else if (null == this.target.getXPath() && null == destination) {
                    StAXOMBuilder builder;
                    OMElement resultOM;
                    destination = synCtx.getEnvelope().getBody();
                    if (synLog.isTraceOrDebugEnabled()) {
                        synLog.traceOrDebug((Object)("The target node " + destination));
                    }
                    if ((5 == itemKind || 7 == itemKind || 4 == itemKind) && (resultOM = (builder = new StAXOMBuilder(XMLInputFactory.newInstance().createXMLStreamReader(new StringReader(xqItem.getItemAsString(null))))).getDocumentElement()) != null) {
                        ((OMElement)destination).addChild((OMNode)resultOM);
                    }
                }
            }
            resultSequence.close();
        }
        catch (XQException e) {
            this.handleException("Error during the querying " + e.getMessage(), (Exception)((Object)e));
        }
        catch (XMLStreamException e) {
            this.handleException("Error during retrieving  the Doument Node as  the result " + e.getMessage(), e);
        }
    }

    private void bindVariable(XQDynamicContext xqDynamicContext, MediatorVariable variable, SynapseLog synLog) throws XQException {
        if (variable != null) {
            QName name = variable.getName();
            int type = variable.getType();
            Object value = variable.getValue();
            if (value != null && type != -1) {
                if (synLog.isTraceOrDebugEnabled()) {
                    synLog.traceOrDebug((Object)("Binding a variable to the DynamicContext with a name : " + name + " and a value : " + value));
                }
                switch (type) {
                    case 10: {
                        boolean booleanValue = false;
                        if (value instanceof String) {
                            booleanValue = Boolean.parseBoolean((String)value);
                        } else if (value instanceof Boolean) {
                            booleanValue = (Boolean)value;
                        } else {
                            this.handleException("Incompatible type for the Boolean");
                        }
                        xqDynamicContext.bindBoolean(name, booleanValue, null);
                        break;
                    }
                    case 13: {
                        int intValue = -1;
                        if (value instanceof String) {
                            try {
                                intValue = Integer.parseInt((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the Integer", e);
                            }
                        } else if (value instanceof Integer) {
                            intValue = (Integer)value;
                        } else {
                            this.handleException("Incompatible type for the Integer");
                        }
                        if (intValue == -1) break;
                        xqDynamicContext.bindInt(name, intValue, null);
                        break;
                    }
                    case 12: {
                        int intValue = -1;
                        if (value instanceof String) {
                            try {
                                intValue = Integer.parseInt((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' for the Int", e);
                            }
                        } else if (value instanceof Integer) {
                            intValue = (Integer)value;
                        } else {
                            this.handleException("Incompatible type for the Int");
                        }
                        if (intValue == -1) break;
                        xqDynamicContext.bindInt(name, intValue, null);
                        break;
                    }
                    case 15: {
                        long longValue = -1L;
                        if (value instanceof String) {
                            try {
                                longValue = Long.parseLong((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the long ", e);
                            }
                        } else if (value instanceof Long) {
                            longValue = (Long)value;
                        } else {
                            this.handleException("Incompatible type for the Long");
                        }
                        if (longValue == -1L) break;
                        xqDynamicContext.bindLong(name, longValue, null);
                        break;
                    }
                    case 14: {
                        short shortValue = -1;
                        if (value instanceof String) {
                            try {
                                shortValue = Short.parseShort((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the short ", e);
                            }
                        } else if (value instanceof Short) {
                            shortValue = (Short)value;
                        } else {
                            this.handleException("Incompatible type for the Short");
                        }
                        if (shortValue == -1) break;
                        xqDynamicContext.bindShort(name, shortValue, null);
                        break;
                    }
                    case 18: {
                        double doubleValue = -1.0;
                        if (value instanceof String) {
                            try {
                                doubleValue = Double.parseDouble((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the double ", e);
                            }
                        } else if (value instanceof Double) {
                            doubleValue = (Double)value;
                        } else {
                            this.handleException("Incompatible type for the Double");
                        }
                        if (doubleValue == -1.0) break;
                        xqDynamicContext.bindDouble(name, doubleValue, null);
                        break;
                    }
                    case 20: {
                        float floatValue = -1.0f;
                        if (value instanceof String) {
                            try {
                                floatValue = Float.parseFloat((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the float ", e);
                            }
                        } else if (value instanceof Float) {
                            floatValue = ((Float)value).floatValue();
                        } else {
                            this.handleException("Incompatible type for the Float");
                        }
                        if (floatValue == -1.0f) break;
                        xqDynamicContext.bindFloat(name, floatValue, null);
                        break;
                    }
                    case 31: {
                        byte byteValue = -1;
                        if (value instanceof String) {
                            try {
                                byteValue = Byte.parseByte((String)value);
                            }
                            catch (NumberFormatException e) {
                                this.handleException("Incompatible value '" + value + "' " + "for the byte ", e);
                            }
                        } else if (value instanceof Byte) {
                            byteValue = (Byte)value;
                        } else {
                            this.handleException("Incompatible type for the Byte");
                        }
                        if (byteValue == -1) break;
                        xqDynamicContext.bindByte(name, byteValue, null);
                        break;
                    }
                    case 29: {
                        if (value instanceof String) {
                            xqDynamicContext.bindObject(name, value, null);
                            break;
                        }
                        this.handleException("Incompatible type for the String");
                        break;
                    }
                    case 4: {
                        this.bindOMNode(name, value, xqDynamicContext);
                        break;
                    }
                    case 7: {
                        this.bindOMNode(name, value, xqDynamicContext);
                        break;
                    }
                    case 5: {
                        this.bindOMNode(name, value, xqDynamicContext);
                        break;
                    }
                    default: {
                        this.handleException("Unsupported  type for the binding type" + type + " in the variable name " + name);
                    }
                }
            }
        }
    }

    private void bindOMNode(QName name, Object value, XQDynamicContext xqDynamicContext) throws XQException {
        OMElement variableValue = null;
        if (value instanceof String) {
            variableValue = SynapseConfigUtils.stringToOM((String)((String)value));
        } else if (value instanceof OMElement) {
            variableValue = (OMElement)value;
        }
        if (variableValue != null) {
            if (this.useDOMSource) {
                xqDynamicContext.bindObject(name, (Object)new DOMSource(((Element)ElementHelper.importOMElement((OMElement)variableValue, (OMFactory)DOOMAbstractFactory.getOMFactory())).getOwnerDocument()), null);
            } else {
                xqDynamicContext.bindDocument(name, SynapseConfigUtils.getInputStream((Object)variableValue), null, null);
            }
        }
    }

    private void handleException(String msg, Exception e) {
        this.log.error((Object)msg, (Throwable)e);
        throw new SynapseException(msg, (Throwable)e);
    }

    private void handleException(String msg) {
        this.log.error((Object)msg);
        throw new SynapseException(msg);
    }

    public Value getQueryKey() {
        return this.queryKey;
    }

    public void setQueryKey(Value queryKey) {
        this.queryKey = queryKey;
    }

    public String getQuerySource() {
        return this.querySource;
    }

    public void setQuerySource(String querySource) {
        this.querySource = querySource;
    }

    public void addAllVariables(List<MediatorVariable> list) {
        this.variables.addAll(list);
    }

    public void addVariable(MediatorVariable variable) {
        this.variables.add(variable);
    }

    public List<MediatorProperty> getDataSourceProperties() {
        return this.dataSourceProperties;
    }

    public List<MediatorVariable> getVariables() {
        return this.variables;
    }

    public SynapseXPath getTarget() {
        return this.target.getXPath();
    }

    public void setTarget(SynapseXPath source) {
        this.target.setXPath(source);
    }

    public void addAllDataSourceProperties(List<MediatorProperty> list) {
        this.dataSourceProperties.addAll(list);
    }

    public boolean isUseDOMSource() {
        return this.useDOMSource;
    }

    public void setUseDOMSource(boolean useDOMSource) {
        this.useDOMSource = useDOMSource;
    }
}

