/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.config;

import java.util.AbstractList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.infinispan.commons.util.Util;
import org.infinispan.config.AbstractFluentConfigurationBean;
import org.infinispan.config.ConfigurationBeanVisitor;
import org.infinispan.config.ConfigurationDoc;
import org.infinispan.config.ConfigurationDocRef;
import org.infinispan.config.FluentConfiguration;
import org.infinispan.config.GrouperConfiguration;
import org.infinispan.distribution.group.Grouper;

@XmlAccessorType(value=XmlAccessType.PROPERTY)
@ConfigurationDoc(name="groups", desc="Configuration for various grouper definitions. See the user guide for more information")
public class GroupsConfiguration
extends AbstractFluentConfigurationBean
implements FluentConfiguration.GroupsConfig {
    List<Grouper<?>> groupers = new LinkedList();
    @ConfigurationDocRef(targetElement="enabled", bean=GroupsConfiguration.class)
    Boolean enabled = false;

    public void accept(ConfigurationBeanVisitor v) {
        v.visitGroupConfig(this);
    }

    @XmlElement(name="grouper")
    public List<GrouperConfiguration> getGroupGeneratorConfigurations() {
        return new AbstractList<GrouperConfiguration>(){

            @Override
            public GrouperConfiguration get(int index) {
                return new GrouperConfiguration(GroupsConfiguration.this.groupers.get(index).getClass());
            }

            @Override
            public boolean add(GrouperConfiguration e) {
                return GroupsConfiguration.this.groupers.add(new LazyGrouper(e.getClazz()));
            }

            @Override
            public int size() {
                return GroupsConfiguration.this.groupers.size();
            }
        };
    }

    @Override
    public Boolean isEnabled() {
        return this.enabled;
    }

    @XmlAttribute(name="enabled")
    public void setEnabled(Boolean enabled) {
        this.enabled(enabled);
    }

    @Override
    public FluentConfiguration.GroupsConfig enabled(Boolean enabled) {
        this.enabled = enabled;
        this.testImmutability("enabled");
        return this;
    }

    @Override
    public FluentConfiguration.GroupsConfig groupers(List<Grouper<?>> groupers) {
        this.groupers = groupers;
        this.testImmutability("groupers");
        return this;
    }

    @Override
    public List<Grouper<?>> getGroupers() {
        return this.groupers;
    }

    public boolean equals(Object obj) {
        if (obj instanceof GroupsConfiguration) {
            GroupsConfiguration that = (GroupsConfiguration)obj;
            if (this.enabled != null && !this.enabled.equals(that.enabled)) {
                return false;
            }
            return this.groupers == null || this.groupers.equals(that.groupers);
        }
        return false;
    }

    public int hashCode() {
        int result = this.enabled != null ? this.enabled.hashCode() : 0;
        result = 31 * result + (this.groupers != null ? this.groupers.hashCode() : 0);
        return result;
    }

    @Override
    public GroupsConfiguration clone() throws CloneNotSupportedException {
        GroupsConfiguration dolly = (GroupsConfiguration)super.clone();
        dolly.enabled = this.enabled;
        dolly.groupers = new LinkedList();
        for (Grouper<?> g : this.groupers) {
            dolly.groupers.add(g);
        }
        return dolly;
    }

    private class LazyGrouper<T>
    implements Grouper<T> {
        private final String className;
        private transient Grouper<T> delegate;

        public LazyGrouper(String className) {
            this.className = className;
        }

        @Override
        public String computeGroup(T key, String group) {
            return this.delegate().computeGroup(key, group);
        }

        @Override
        public Class<T> getKeyType() {
            return this.delegate().getKeyType();
        }

        private Grouper<T> delegate() {
            if (this.delegate == null) {
                this.delegate = (Grouper)Util.getInstance(this.className, GroupsConfiguration.this.config.getClassLoader());
            }
            return this.delegate;
        }
    }
}

