/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.AsyncStoreConfigurationBuilder;
import org.infinispan.configuration.cache.CacheStoreConfiguration;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfigurationBuilder;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractStoreConfigurationBuilder<T extends CacheStoreConfiguration, S extends AbstractStoreConfigurationBuilder<T, S>>
extends AbstractLoaderConfigurationBuilder<T, S>
implements CacheStoreConfigurationBuilder<T, S> {
    private static final Log log = LogFactory.getLog(AbstractStoreConfigurationBuilder.class);
    protected final AsyncStoreConfigurationBuilder<S> async = new AsyncStoreConfigurationBuilder(this);
    protected final SingletonStoreConfigurationBuilder<S> singletonStore = new SingletonStoreConfigurationBuilder(this);
    protected boolean fetchPersistentState = false;
    protected boolean ignoreModifications = false;
    protected boolean purgeOnStartup = false;
    protected int purgerThreads = 1;
    protected boolean purgeSynchronously = false;

    public AbstractStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public AsyncStoreConfigurationBuilder<S> async() {
        return this.async;
    }

    @Override
    public SingletonStoreConfigurationBuilder<S> singletonStore() {
        return this.singletonStore;
    }

    @Override
    public S fetchPersistentState(boolean b) {
        this.fetchPersistentState = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S ignoreModifications(boolean b) {
        this.ignoreModifications = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeOnStartup(boolean b) {
        this.purgeOnStartup = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgerThreads(int i) {
        this.purgerThreads = i;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public S purgeSynchronously(boolean b) {
        this.purgeSynchronously = b;
        return (S)((AbstractStoreConfigurationBuilder)this.self());
    }

    @Override
    public void validate() {
        this.async.validate();
        this.singletonStore.validate();
        ConfigurationBuilder builder = this.getBuilder();
        if (!this.loaders().shared() && !this.fetchPersistentState && !this.purgeOnStartup && builder.clustering().cacheMode().isClustered()) {
            log.staleEntriesWithoutFetchPersistentStateOrPurgeOnStartup();
        }
        if (this.loaders().shared() && !this.loaders().preload() && builder.indexing().enabled() && builder.indexing().indexLocalOnly()) {
            log.localIndexingWithSharedCacheLoaderRequiresPreload();
        }
    }
}

