/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.AsyncConfiguration;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.remoting.ReplicationQueue;

public class AsyncConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<AsyncConfiguration> {
    private boolean asyncMarshalling = false;
    private ReplicationQueue replicationQueue;
    private long replicationQueueInterval = TimeUnit.SECONDS.toMillis(5L);
    private int replicationQueueMaxElements = 1000;
    private boolean useReplicationQueue = false;

    protected AsyncConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public AsyncConfigurationBuilder asyncMarshalling() {
        this.asyncMarshalling = true;
        return this;
    }

    public AsyncConfigurationBuilder asyncMarshalling(boolean async) {
        this.asyncMarshalling = async;
        return this;
    }

    public AsyncConfigurationBuilder syncMarshalling() {
        this.asyncMarshalling = false;
        return this;
    }

    public AsyncConfigurationBuilder replQueue(ReplicationQueue replicationQueue) {
        this.replicationQueue = replicationQueue;
        return this;
    }

    public AsyncConfigurationBuilder replQueueInterval(long interval) {
        this.replicationQueueInterval = interval;
        return this;
    }

    public AsyncConfigurationBuilder replQueueInterval(long interval, TimeUnit unit) {
        return this.replQueueInterval(unit.toMillis(interval));
    }

    public AsyncConfigurationBuilder replQueueMaxElements(int elements) {
        this.replicationQueueMaxElements = elements;
        return this;
    }

    public AsyncConfigurationBuilder useReplQueue(boolean use) {
        this.useReplicationQueue = use;
        return this;
    }

    @Override
    public void validate() {
        if (this.useReplicationQueue && this.getClusteringBuilder().cacheMode().isDistributed()) {
            throw new CacheConfigurationException("Use of the replication queue is invalid when using DISTRIBUTED mode.");
        }
        if (this.useReplicationQueue && this.getClusteringBuilder().cacheMode().isSynchronous()) {
            throw new CacheConfigurationException("Use of the replication queue is only allowed with an ASYNCHRONOUS cluster mode.");
        }
    }

    @Override
    public AsyncConfiguration create() {
        return new AsyncConfiguration(this.asyncMarshalling, this.replicationQueue, this.replicationQueueInterval, this.replicationQueueMaxElements, this.useReplicationQueue);
    }

    public AsyncConfigurationBuilder read(AsyncConfiguration template) {
        this.asyncMarshalling = template.asyncMarshalling();
        this.replicationQueue = template.replQueue();
        this.replicationQueueInterval = template.replQueueInterval();
        this.replicationQueueMaxElements = template.replQueueMaxElements();
        this.useReplicationQueue = template.useReplQueue();
        return this;
    }

    public String toString() {
        return "AsyncConfigurationBuilder{asyncMarshalling=" + this.asyncMarshalling + ", replicationQueue=" + this.replicationQueue + ", replicationQueueInterval=" + this.replicationQueueInterval + ", replicationQueueMaxElements=" + this.replicationQueueMaxElements + ", useReplicationQueue=" + this.useReplicationQueue + '}';
    }
}

