/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.config.parsing.XmlConfigHelper;
import org.infinispan.configuration.cache.AbstractLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfiguration;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;

public class ClusterCacheLoaderConfigurationBuilder
extends AbstractLoaderConfigurationBuilder<ClusterCacheLoaderConfiguration, ClusterCacheLoaderConfigurationBuilder> {
    private long remoteCallTimeout;

    public ClusterCacheLoaderConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public ClusterCacheLoaderConfigurationBuilder self() {
        return this;
    }

    public ClusterCacheLoaderConfigurationBuilder remoteCallTimeout(long remoteCallTimeout) {
        this.remoteCallTimeout = remoteCallTimeout;
        return this;
    }

    public ClusterCacheLoaderConfigurationBuilder remoteCallTimeout(long remoteCallTimeout, TimeUnit unit) {
        this.remoteCallTimeout = unit.toMillis(remoteCallTimeout);
        return this;
    }

    @Override
    public ClusterCacheLoaderConfigurationBuilder withProperties(Properties p) {
        this.properties = p;
        XmlConfigHelper.setValues(this, this.properties, false, true);
        return this;
    }

    @Override
    public void validate() {
    }

    @Override
    public ClusterCacheLoaderConfiguration create() {
        return new ClusterCacheLoaderConfiguration(this.remoteCallTimeout, TypedProperties.toTypedProperties(this.properties));
    }

    public ClusterCacheLoaderConfigurationBuilder read(ClusterCacheLoaderConfiguration template) {
        this.remoteCallTimeout = template.remoteCallTimeout();
        this.properties = template.properties();
        return this;
    }
}

