/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractConfigurationChildBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.EvictionConfiguration;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class EvictionConfigurationBuilder
extends AbstractConfigurationChildBuilder
implements Builder<EvictionConfiguration> {
    private static final Log log = LogFactory.getLog(EvictionConfigurationBuilder.class);
    private int maxEntries = -1;
    private EvictionStrategy strategy = EvictionStrategy.NONE;
    private EvictionThreadPolicy threadPolicy = EvictionThreadPolicy.DEFAULT;

    EvictionConfigurationBuilder(ConfigurationBuilder builder) {
        super(builder);
    }

    public EvictionConfigurationBuilder strategy(EvictionStrategy evictionStrategy) {
        this.strategy = evictionStrategy;
        return this;
    }

    EvictionStrategy strategy() {
        return this.strategy;
    }

    public EvictionConfigurationBuilder threadPolicy(EvictionThreadPolicy policy) {
        this.threadPolicy = policy;
        return this;
    }

    public EvictionConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    @Override
    public void validate() {
        if (!this.strategy.isEnabled() && this.getBuilder().loaders().passivation()) {
            log.passivationWithoutEviction();
        }
        if (this.strategy == EvictionStrategy.FIFO) {
            log.warn("FIFO strategy is deprecated, LRU will be used instead");
        }
        if (this.strategy.isEnabled() && this.maxEntries <= 0) {
            throw new CacheConfigurationException("Eviction maxEntries value cannot be less than or equal to zero if eviction is enabled");
        }
        if (this.maxEntries > 0 && !this.strategy.isEnabled()) {
            this.strategy = EvictionStrategy.LIRS;
            log.debugf("Max entries configured (%d) without eviction strategy. Eviction strategy overriden to %s", this.maxEntries, (Object)this.strategy);
        }
    }

    @Override
    public EvictionConfiguration create() {
        return new EvictionConfiguration(this.maxEntries, this.strategy, this.threadPolicy);
    }

    public EvictionConfigurationBuilder read(EvictionConfiguration template) {
        this.maxEntries = template.maxEntries();
        this.strategy = template.strategy();
        this.threadPolicy = template.threadPolicy();
        return this;
    }

    public String toString() {
        return "EvictionConfigurationBuilder{maxEntries=" + this.maxEntries + ", strategy=" + (Object)((Object)this.strategy) + ", threadPolicy=" + (Object)((Object)this.threadPolicy) + '}';
    }
}

