/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractLockSupportStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.file.FileCacheStore;

@BuiltBy(value=FileCacheStoreConfigurationBuilder.class)
@ConfigurationFor(value=FileCacheStore.class)
public class FileCacheStoreConfiguration
extends AbstractLockSupportStoreConfiguration {
    private final String location;
    private final long fsyncInterval;
    private final FileCacheStoreConfigurationBuilder.FsyncMode fsyncMode;
    private final int streamBufferSize;

    FileCacheStoreConfiguration(String location, long fsyncInterval, FileCacheStoreConfigurationBuilder.FsyncMode fsyncMode, int streamBufferSize, long lockAcquistionTimeout, int lockConcurrencyLevel, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(lockAcquistionTimeout, lockConcurrencyLevel, purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.location = location;
        this.fsyncInterval = fsyncInterval;
        this.fsyncMode = fsyncMode;
        this.streamBufferSize = streamBufferSize;
    }

    public long fsyncInterval() {
        return this.fsyncInterval;
    }

    public FileCacheStoreConfigurationBuilder.FsyncMode fsyncMode() {
        return this.fsyncMode;
    }

    public String location() {
        return this.location;
    }

    public int streamBufferSize() {
        return this.streamBufferSize;
    }

    public String toString() {
        return "FileCacheStoreConfiguration{fsyncInterval=" + this.fsyncInterval + ", location='" + this.location + '\'' + ", fsyncMode=" + (Object)((Object)this.fsyncMode) + ", streamBufferSize=" + this.streamBufferSize + ", lockAcquistionTimeout=" + this.lockAcquistionTimeout() + ", lockConcurrencyLevel=" + this.lockConcurrencyLevel() + ", purgeOnStartup=" + this.purgeOnStartup() + ", purgeSynchronously=" + this.purgeSynchronously() + ", purgerThreads=" + this.purgerThreads() + ", fetchPersistentState=" + this.fetchPersistentState() + ", ignoreModifications=" + this.ignoreModifications() + ", properties=" + this.properties() + ", async=" + this.async() + ", singletonStore=" + this.singletonStore() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        FileCacheStoreConfiguration that = (FileCacheStoreConfiguration)o;
        if (this.fsyncInterval != that.fsyncInterval) {
            return false;
        }
        if (this.streamBufferSize != that.streamBufferSize) {
            return false;
        }
        if (this.fsyncMode != that.fsyncMode) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(that.location) : that.location != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + (int)(this.fsyncInterval ^ this.fsyncInterval >>> 32);
        result = 31 * result + (this.fsyncMode != null ? this.fsyncMode.hashCode() : 0);
        result = 31 * result + this.streamBufferSize;
        return result;
    }
}

