/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.hash.Hash;
import org.infinispan.configuration.cache.GroupsConfiguration;
import org.infinispan.configuration.cache.StateTransferConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;

public class HashConfiguration {
    private final ConsistentHashFactory consistentHashFactory;
    private final Hash hash;
    private final int numOwners;
    private final int numSegments;
    private final GroupsConfiguration groupsConfiguration;
    private final StateTransferConfiguration stateTransferConfiguration;

    HashConfiguration(ConsistentHashFactory consistentHashFactory, Hash hash, int numOwners, int numSegments, GroupsConfiguration groupsConfiguration, StateTransferConfiguration stateTransferConfiguration) {
        this.consistentHashFactory = consistentHashFactory;
        this.hash = hash;
        this.numOwners = numOwners;
        this.numSegments = numSegments;
        this.groupsConfiguration = groupsConfiguration;
        this.stateTransferConfiguration = stateTransferConfiguration;
    }

    @Deprecated
    public ConsistentHash consistentHash() {
        return null;
    }

    public ConsistentHashFactory consistentHashFactory() {
        return this.consistentHashFactory;
    }

    public Hash hash() {
        return this.hash;
    }

    public int numOwners() {
        return this.numOwners;
    }

    @Deprecated
    public int numVirtualNodes() {
        return 1;
    }

    public int numSegments() {
        return this.numSegments;
    }

    @Deprecated
    public boolean rehashEnabled() {
        return this.stateTransferConfiguration.fetchInMemoryState();
    }

    @Deprecated
    public long rehashRpcTimeout() {
        return this.stateTransferConfiguration.timeout();
    }

    @Deprecated
    public long rehashWait() {
        return this.stateTransferConfiguration.timeout();
    }

    public GroupsConfiguration groups() {
        return this.groupsConfiguration;
    }

    public String toString() {
        return "HashConfiguration{consistentHashFactory=" + this.consistentHashFactory + ", hash=" + this.hash + ", numOwners=" + this.numOwners + ", numSegments=" + this.numSegments + ", groupsConfiguration=" + this.groupsConfiguration + ", stateTransferConfiguration=" + this.stateTransferConfiguration + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashConfiguration that = (HashConfiguration)o;
        if (this.numOwners != that.numOwners) {
            return false;
        }
        if (this.numSegments != that.numSegments) {
            return false;
        }
        if (this.consistentHashFactory != null ? !this.consistentHashFactory.equals(that.consistentHashFactory) : that.consistentHashFactory != null) {
            return false;
        }
        if (this.groupsConfiguration != null ? !this.groupsConfiguration.equals(that.groupsConfiguration) : that.groupsConfiguration != null) {
            return false;
        }
        if (this.hash != null ? !this.hash.equals(that.hash) : that.hash != null) {
            return false;
        }
        return !(this.stateTransferConfiguration != null ? !this.stateTransferConfiguration.equals(that.stateTransferConfiguration) : that.stateTransferConfiguration != null);
    }

    public int hashCode() {
        int result = this.consistentHashFactory != null ? this.consistentHashFactory.hashCode() : 0;
        result = 31 * result + (this.hash != null ? this.hash.hashCode() : 0);
        result = 31 * result + this.numOwners;
        result = 31 * result + this.numSegments;
        result = 31 * result + (this.groupsConfiguration != null ? this.groupsConfiguration.hashCode() : 0);
        result = 31 * result + (this.stateTransferConfiguration != null ? this.stateTransferConfiguration.hashCode() : 0);
        return result;
    }
}

