/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.hash.MurmurHash3;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.GroupsConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.distribution.ch.ConsistentHash;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class HashConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<HashConfiguration> {
    private static final Log log = LogFactory.getLog(HashConfigurationBuilder.class);
    private ConsistentHashFactory consistentHashFactory;
    private Hash hash = new MurmurHash3();
    private int numOwners = 2;
    private int numSegments = 60;
    private final GroupsConfigurationBuilder groupsConfigurationBuilder;

    HashConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
        this.groupsConfigurationBuilder = new GroupsConfigurationBuilder(builder);
    }

    @Deprecated
    public HashConfigurationBuilder consistentHash(ConsistentHash consistentHash) {
        log.consistentHashDeprecated();
        return this;
    }

    public HashConfigurationBuilder consistentHashFactory(ConsistentHashFactory consistentHashFactory) {
        this.consistentHashFactory = consistentHashFactory;
        return this;
    }

    public HashConfigurationBuilder numOwners(int numOwners) {
        if (numOwners < 1) {
            throw new IllegalArgumentException("numOwners cannot be less than 1");
        }
        this.numOwners = numOwners;
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder numVirtualNodes(int numVirtualNodes) {
        log.hashNumVirtualNodesDeprecated();
        return this;
    }

    public HashConfigurationBuilder numSegments(int numSegments) {
        if (numSegments < 1) {
            throw new IllegalArgumentException("numSegments cannot be less than 1");
        }
        this.numSegments = numSegments;
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashEnabled() {
        this.stateTransfer().fetchInMemoryState(true);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashEnabled(boolean enabled) {
        this.stateTransfer().fetchInMemoryState(enabled);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashDisabled() {
        this.stateTransfer().fetchInMemoryState(false);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashRpcTimeout(long rehashRpcTimeout) {
        this.stateTransfer().timeout(rehashRpcTimeout);
        return this;
    }

    @Deprecated
    public HashConfigurationBuilder rehashWait(long rehashWait) {
        return this;
    }

    public HashConfigurationBuilder hash(Hash hash) {
        this.hash = hash;
        return this;
    }

    public GroupsConfigurationBuilder groups() {
        return this.groupsConfigurationBuilder;
    }

    @Override
    public void validate() {
        this.groupsConfigurationBuilder.validate();
    }

    @Override
    public HashConfiguration create() {
        return new HashConfiguration(this.consistentHashFactory, this.hash, this.numOwners, this.numSegments, this.groupsConfigurationBuilder.create(), this.stateTransfer().create());
    }

    public HashConfigurationBuilder read(HashConfiguration template) {
        this.consistentHashFactory = template.consistentHashFactory();
        this.hash = template.hash();
        this.numOwners = template.numOwners();
        this.numSegments = template.numSegments();
        this.groupsConfigurationBuilder.read(template.groups());
        return this;
    }

    public String toString() {
        return "HashConfigurationBuilder{consistentHashFactory=" + this.consistentHashFactory + ", hash=" + this.hash + ", numOwners=" + this.numOwners + ", numSegments=" + this.numSegments + ", groups=" + this.groupsConfigurationBuilder + '}';
    }
}

