/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.concurrent.TimeUnit;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.configuration.Builder;
import org.infinispan.configuration.cache.AbstractClusteringConfigurationChildBuilder;
import org.infinispan.configuration.cache.ClusteringConfigurationBuilder;
import org.infinispan.configuration.cache.L1Configuration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class L1ConfigurationBuilder
extends AbstractClusteringConfigurationChildBuilder
implements Builder<L1Configuration> {
    private static final Log log = LogFactory.getLog(L1ConfigurationBuilder.class);
    private boolean enabled = false;
    private int invalidationThreshold = 0;
    private long lifespan = TimeUnit.MINUTES.toMillis(10L);
    private Boolean onRehash = null;
    private long cleanupTaskFrequency = TimeUnit.MINUTES.toMillis(10L);

    L1ConfigurationBuilder(ClusteringConfigurationBuilder builder) {
        super(builder);
    }

    public L1ConfigurationBuilder invalidationThreshold(int invalidationThreshold) {
        this.invalidationThreshold = invalidationThreshold;
        return this;
    }

    public L1ConfigurationBuilder lifespan(long lifespan) {
        this.lifespan = lifespan;
        return this;
    }

    public L1ConfigurationBuilder lifespan(long lifespan, TimeUnit unit) {
        return this.lifespan(unit.toMillis(lifespan));
    }

    public L1ConfigurationBuilder cleanupTaskFrequency(long frequencyMillis) {
        this.cleanupTaskFrequency = frequencyMillis;
        return this;
    }

    public L1ConfigurationBuilder cleanupTaskFrequency(long frequencyMillis, TimeUnit unit) {
        return this.cleanupTaskFrequency(unit.toMillis(frequencyMillis));
    }

    public L1ConfigurationBuilder enableOnRehash() {
        this.onRehash = true;
        return this;
    }

    public L1ConfigurationBuilder onRehash(boolean enabled) {
        this.onRehash = enabled;
        return this;
    }

    public L1ConfigurationBuilder disableOnRehash() {
        this.onRehash = false;
        return this;
    }

    public L1ConfigurationBuilder l1OnRehash(boolean l1OnRehash) {
        this.onRehash = l1OnRehash;
        return this;
    }

    public L1ConfigurationBuilder enable() {
        this.enabled = true;
        return this;
    }

    public L1ConfigurationBuilder disable() {
        this.enabled = false;
        this.onRehash = null;
        return this;
    }

    public L1ConfigurationBuilder enabled(boolean enabled) {
        this.enabled = enabled;
        this.onRehash = enabled ? this.onRehash : null;
        return this;
    }

    @Override
    public void validate() {
        if (this.enabled) {
            if (!this.clustering().cacheMode().isDistributed()) {
                throw new CacheConfigurationException("Enabling the L1 cache is only supported when using DISTRIBUTED as a cache mode.  Your cache mode is set to " + this.clustering().cacheMode().friendlyCacheModeString());
            }
            if (this.lifespan < 1L) {
                throw new CacheConfigurationException("Using a L1 lifespan of 0 or a negative value is meaningless");
            }
        } else if (this.onRehash != null && this.onRehash.booleanValue()) {
            throw new CacheConfigurationException("Can only move entries to L1 on rehash when L1 is enabled");
        }
    }

    @Override
    public L1Configuration create() {
        boolean finalOnRehash;
        if (this.onRehash != null) {
            finalOnRehash = this.onRehash;
        } else {
            finalOnRehash = false;
            if (this.enabled) {
                log.debug("L1 is enabled and L1OnRehash was not defined, enabling it");
                finalOnRehash = true;
            }
        }
        return new L1Configuration(this.enabled, this.invalidationThreshold, this.lifespan, finalOnRehash, this.cleanupTaskFrequency);
    }

    public L1ConfigurationBuilder read(L1Configuration template) {
        this.enabled = template.enabled();
        this.invalidationThreshold = template.invalidationThreshold();
        this.lifespan = template.lifespan();
        this.onRehash = template.onRehash();
        this.cleanupTaskFrequency = template.cleanupTaskFrequency();
        return this;
    }

    public String toString() {
        return "L1ConfigurationBuilder{enabled=" + this.enabled + ", invalidationThreshold=" + this.invalidationThreshold + ", lifespan=" + this.lifespan + ", cleanupTaskFrequency=" + this.cleanupTaskFrequency + ", onRehash=" + this.onRehash + '}';
    }
}

