/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.BuiltBy;
import org.infinispan.commons.configuration.ConfigurationFor;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfiguration;
import org.infinispan.configuration.cache.AsyncStoreConfiguration;
import org.infinispan.configuration.cache.SingleFileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.SingletonStoreConfiguration;
import org.infinispan.loaders.file.SingleFileCacheStore;

@BuiltBy(value=SingleFileCacheStoreConfigurationBuilder.class)
@ConfigurationFor(value=SingleFileCacheStore.class)
public class SingleFileCacheStoreConfiguration
extends AbstractStoreConfiguration {
    private final String location;
    private final int maxEntries;

    public SingleFileCacheStoreConfiguration(String location, int maxKeysInMemory, boolean purgeOnStartup, boolean purgeSynchronously, int purgerThreads, boolean fetchPersistentState, boolean ignoreModifications, TypedProperties properties, AsyncStoreConfiguration async, SingletonStoreConfiguration singletonStore) {
        super(purgeOnStartup, purgeSynchronously, purgerThreads, fetchPersistentState, ignoreModifications, properties, async, singletonStore);
        this.location = location;
        this.maxEntries = maxKeysInMemory;
    }

    public String location() {
        return this.location;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SingleFileCacheStoreConfiguration that = (SingleFileCacheStoreConfiguration)o;
        if (this.maxEntries != that.maxEntries) {
            return false;
        }
        return !(this.location != null ? !this.location.equals(that.location) : that.location != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.location != null ? this.location.hashCode() : 0);
        result = 31 * result + this.maxEntries;
        return result;
    }

    public String toString() {
        return "SingleFileCacheStoreConfiguration{location='" + this.location + '\'' + ", maxEntries=" + this.maxEntries + '}';
    }
}

