/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import org.infinispan.commons.configuration.Builder;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.cache.AbstractStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LoadersConfigurationBuilder;
import org.infinispan.configuration.cache.SingleFileCacheStoreConfiguration;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleFileCacheStoreConfigurationBuilder
extends AbstractStoreConfigurationBuilder<SingleFileCacheStoreConfiguration, SingleFileCacheStoreConfigurationBuilder> {
    private static final Log log = LogFactory.getLog(SingleFileCacheStoreConfigurationBuilder.class);
    private String location = "Infinispan-SingleFileCacheStore";
    private int maxEntries = -1;

    public SingleFileCacheStoreConfigurationBuilder(LoadersConfigurationBuilder builder) {
        super(builder);
    }

    @Override
    public SingleFileCacheStoreConfigurationBuilder self() {
        return this;
    }

    public SingleFileCacheStoreConfigurationBuilder location(String location) {
        this.location = location;
        return this;
    }

    public SingleFileCacheStoreConfigurationBuilder maxEntries(int maxEntries) {
        this.maxEntries = maxEntries;
        return this;
    }

    @Override
    public SingleFileCacheStoreConfiguration create() {
        return new SingleFileCacheStoreConfiguration(this.location, this.maxEntries, this.purgeOnStartup, this.purgeSynchronously, this.purgerThreads, this.fetchPersistentState, this.ignoreModifications, TypedProperties.toTypedProperties(this.properties), this.async.create(), this.singletonStore.create());
    }

    @Override
    public Builder<?> read(SingleFileCacheStoreConfiguration template) {
        this.location = template.location();
        this.maxEntries = template.maxEntries();
        this.fetchPersistentState = template.fetchPersistentState();
        this.ignoreModifications = template.ignoreModifications();
        this.properties = template.properties();
        this.purgeOnStartup = template.purgeOnStartup();
        this.purgeSynchronously = template.purgeSynchronously();
        this.async.read(template.async());
        this.singletonStore.read(template.singletonStore());
        return this;
    }
}

