/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.global;

import java.util.Map;
import java.util.Properties;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.util.TypedProperties;
import org.infinispan.configuration.global.AbstractGlobalConfigurationBuilder;
import org.infinispan.configuration.global.ExecutorFactoryConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.executors.DefaultExecutorFactory;

public class ExecutorFactoryConfigurationBuilder
extends AbstractGlobalConfigurationBuilder<ExecutorFactoryConfiguration> {
    private ExecutorFactory factory = new DefaultExecutorFactory();
    private Properties properties = new Properties();

    ExecutorFactoryConfigurationBuilder(GlobalConfigurationBuilder globalConfig) {
        super(globalConfig);
    }

    public ExecutorFactoryConfigurationBuilder factory(ExecutorFactory factory) {
        this.factory = factory;
        return this;
    }

    public ExecutorFactoryConfigurationBuilder addProperty(String key, String value) {
        this.properties.put(key, value);
        return this;
    }

    public ExecutorFactoryConfigurationBuilder withProperties(Properties props) {
        this.properties = props;
        return this;
    }

    @Override
    void validate() {
    }

    @Override
    ExecutorFactoryConfiguration create() {
        return new ExecutorFactoryConfiguration(this.factory, TypedProperties.toTypedProperties(this.properties));
    }

    protected ExecutorFactoryConfigurationBuilder read(ExecutorFactoryConfiguration template) {
        this.factory = template.factory();
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)template.properties());
        return this;
    }

    public String toString() {
        return "ExecutorFactoryConfigurationBuilder{factory=" + this.factory + ", properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutorFactoryConfigurationBuilder that = (ExecutorFactoryConfigurationBuilder)o;
        if (this.factory != null ? !this.factory.equals(that.factory) : that.factory != null) {
            return false;
        }
        return !(this.properties != null ? !this.properties.equals(that.properties) : that.properties != null);
    }

    public int hashCode() {
        int result = this.factory != null ? this.factory.hashCode() : 0;
        result = 31 * result + (this.properties != null ? this.properties.hashCode() : 0);
        return result;
    }
}

