/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.parsing;

import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.executors.ExecutorFactory;
import org.infinispan.commons.hash.Hash;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.StringPropertyReplacer;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForBuilder;
import org.infinispan.configuration.cache.CacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.CacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.ClusterCacheLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.FileCacheStoreConfigurationBuilder;
import org.infinispan.configuration.cache.IndexingConfigurationBuilder;
import org.infinispan.configuration.cache.InterceptorConfiguration;
import org.infinispan.configuration.cache.InterceptorConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyLoaderConfigurationBuilder;
import org.infinispan.configuration.cache.LegacyStoreConfigurationBuilder;
import org.infinispan.configuration.cache.LockSupportStoreConfigurationBuilder;
import org.infinispan.configuration.cache.RecoveryConfigurationBuilder;
import org.infinispan.configuration.cache.VersioningScheme;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.ShutdownHookBehavior;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ConfigurationParser;
import org.infinispan.configuration.parsing.Element;
import org.infinispan.configuration.parsing.Namespace;
import org.infinispan.configuration.parsing.ParseUtils;
import org.infinispan.configuration.parsing.ParsedCacheMode;
import org.infinispan.configuration.parsing.XMLExtendedStreamReader;
import org.infinispan.container.DataContainer;
import org.infinispan.distribution.ch.ConsistentHashFactory;
import org.infinispan.distribution.group.Grouper;
import org.infinispan.eviction.EvictionStrategy;
import org.infinispan.eviction.EvictionThreadPolicy;
import org.infinispan.executors.ScheduledExecutorFactory;
import org.infinispan.interceptors.base.CommandInterceptor;
import org.infinispan.jmx.MBeanServerLookup;
import org.infinispan.loaders.cluster.ClusterCacheLoader;
import org.infinispan.loaders.file.FileCacheStore;
import org.infinispan.loaders.spi.CacheLoader;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.remoting.ReplicationQueue;
import org.infinispan.remoting.transport.Transport;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.lookup.TransactionManagerLookup;
import org.infinispan.util.concurrent.IsolationLevel;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Namespace(uri="urn:infinispan:config:5.2", root="infinispan")
public class Parser52
implements ConfigurationParser {
    private static final Log log = LogFactory.getLog(Parser52.class);

    @Override
    public void readElement(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block5: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case DEFAULT: {
                    this.parseDefaultCache(reader, holder);
                    continue block5;
                }
                case GLOBAL: {
                    this.parseGlobal(reader, holder);
                    continue block5;
                }
                case NAMED_CACHE: {
                    this.parseNamedCache(reader, holder);
                    continue block5;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseNamedCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireSingleAttribute(reader, Attribute.NAME.getLocalName());
        String name = "";
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ConfigurationBuilder builder = holder.getNamedConfigurationBuilders().get(name);
        if (builder == null) {
            builder = holder.newConfigurationBuilder(name);
        }
        this.parseCache(reader, holder);
    }

    private void parseDefaultCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        this.parseCache(reader, holder);
    }

    private void parseCache(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTERING: {
                    this.parseClustering(reader, holder);
                    continue block19;
                }
                case CUSTOM_INTERCEPTORS: {
                    this.parseCustomInterceptors(reader, holder);
                    continue block19;
                }
                case DATA_CONTAINER: {
                    this.parseDataContainer(reader, holder);
                    continue block19;
                }
                case DEADLOCK_DETECTION: {
                    this.parseDeadlockDetection(reader, holder);
                    continue block19;
                }
                case EVICTION: {
                    this.parseEviction(reader, holder);
                    continue block19;
                }
                case EXPIRATION: {
                    this.parseExpiration(reader, holder);
                    continue block19;
                }
                case INDEXING: {
                    this.parseIndexing(reader, holder);
                    continue block19;
                }
                case INVOCATION_BATCHING: {
                    this.parseInvocationBatching(reader, holder);
                    continue block19;
                }
                case JMX_STATISTICS: {
                    this.parseJmxStatistics(reader, holder);
                    continue block19;
                }
                case LOADERS: {
                    this.parseLoaders(reader, holder);
                    continue block19;
                }
                case LOCKING: {
                    this.parseLocking(reader, holder);
                    continue block19;
                }
                case MODULES: {
                    this.parseModules(reader, holder);
                    continue block19;
                }
                case LAZY_DESERIALIZATION: 
                case STORE_AS_BINARY: {
                    this.parseStoreAsBinary(reader, holder);
                    continue block19;
                }
                case TRANSACTION: {
                    this.parseTransaction(reader, holder);
                    continue block19;
                }
                case UNSAFE: {
                    this.parseUnsafe(reader, holder);
                    continue block19;
                }
                case VERSIONING: {
                    this.parseVersioning(reader, holder);
                    continue block19;
                }
                case SITES: {
                    this.parseLocalSites(reader, holder);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseModules(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            reader.handleAny(holder);
        }
    }

    private void parseVersioning(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        builder.versioning().disable();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case VERSIONING_SCHEME: {
                    builder.versioning().scheme(VersioningScheme.valueOf(value));
                    continue block4;
                }
                case ENABLED: {
                    builder.versioning().enable();
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseGlobalSites(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder gcb = holder.getGlobalConfigurationBuilder();
        ParseUtils.requireSingleAttribute(reader, "local");
        String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(0));
        gcb.site().localSite(value);
        ParseUtils.requireNoContent(reader);
    }

    private void parseLocalSites(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder ccb = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireNoAttributes(reader);
        boolean isEmptyTag = false;
        block4: while (reader.hasNext() && reader.nextTag() != 2) {
            isEmptyTag = true;
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUPS: {
                    ccb.sites().backups().clear();
                    this.parseBackups(reader, ccb);
                    continue block4;
                }
                case BACKUP_FOR: {
                    this.parseBackupFor(reader, ccb);
                    continue block4;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!isEmptyTag) {
            ccb.sites().backups().clear();
            ccb.sites().backupFor().reset();
        }
    }

    private void parseBackupFor(XMLExtendedStreamReader reader, ConfigurationBuilder ccb) throws XMLStreamException {
        ccb.sites().backupFor().reset();
        BackupForBuilder backupForBuilder = ccb.sites().backupFor();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_SITE: {
                    backupForBuilder.remoteSite(value);
                    continue block4;
                }
                case REMOTE_CACHE: {
                    backupForBuilder.remoteCache(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseBackups(XMLExtendedStreamReader reader, ConfigurationBuilder ccb) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case BACKUP: {
                    this.parseBackup(reader, ccb);
                }
            }
            ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseBackup(XMLExtendedStreamReader reader, ConfigurationBuilder ccb) throws XMLStreamException {
        BackupConfigurationBuilder backup = ccb.sites().addBackup();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case TIMEOUT: {
                    backup.replicationTimeout(Long.parseLong(value));
                    continue block9;
                }
                case STRATEGY: {
                    backup.strategy(BackupConfiguration.BackupStrategy.valueOf(value));
                    continue block9;
                }
                case SITE: {
                    backup.site(value);
                    continue block9;
                }
                case BACKUP_FAILURE_POLICY: {
                    backup.backupFailurePolicy(BackupFailurePolicy.valueOf(value));
                    continue block9;
                }
                case USE_TWO_PHASE_COMMIT: {
                    backup.useTwoPhaseCommit(Boolean.parseBoolean(value));
                    continue block9;
                }
                case FAILURE_POLICY_CLASS: {
                    backup.failurePolicyClass(value);
                    continue block9;
                }
                case ENABLED: {
                    backup.enabled(Boolean.parseBoolean(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        this.parseTakeOffline(reader, backup);
    }

    private void parseTakeOffline(XMLExtendedStreamReader reader, BackupConfigurationBuilder backup) throws XMLStreamException {
        int count = 0;
        while (reader.hasNext() && reader.nextTag() != 2) {
            ++count;
            Element takeOffline = Element.forName(reader.getLocalName());
            block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
                ParseUtils.requireNoNamespaceAttribute(reader, i);
                String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
                Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                switch (attribute) {
                    case AFTER_FAILURES: {
                        backup.takeOffline().afterFailures(Integer.parseInt(value));
                        continue block5;
                    }
                    case MIN_TIME_TO_WAIT: {
                        backup.takeOffline().minTimeToWait(Long.parseLong(value));
                        continue block5;
                    }
                    default: {
                        throw ParseUtils.unexpectedElement(reader);
                    }
                }
            }
            ParseUtils.requireNoContent(reader);
        }
        if (count > 1) {
            throw new CacheConfigurationException("Only one 'takeOffline' element allowed within a 'backup'");
        }
    }

    private void parseTransaction(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        boolean forceSetTransactional = false;
        boolean transactionModeSpecified = false;
        block18: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AUTO_COMMIT: {
                    builder.transaction().autoCommit(Boolean.parseBoolean(value));
                    continue block18;
                }
                case CACHE_STOP_TIMEOUT: {
                    builder.transaction().cacheStopTimeout(Long.parseLong(value));
                    continue block18;
                }
                case EAGER_LOCK_SINGLE_NODE: {
                    builder.transaction().eagerLockingSingleNode(Boolean.parseBoolean(value));
                    continue block18;
                }
                case LOCKING_MODE: {
                    builder.transaction().lockingMode(LockingMode.valueOf(value));
                    continue block18;
                }
                case SYNC_COMMIT_PHASE: {
                    builder.transaction().syncCommitPhase(Boolean.parseBoolean(value));
                    continue block18;
                }
                case SYNC_ROLLBACK_PHASE: {
                    builder.transaction().syncRollbackPhase(Boolean.parseBoolean(value));
                    continue block18;
                }
                case TRANSACTION_MANAGER_LOOKUP_CLASS: {
                    builder.transaction().transactionManagerLookup((TransactionManagerLookup)Util.getInstance(value, holder.getClassLoader()));
                    forceSetTransactional = true;
                    continue block18;
                }
                case TRANSACTION_MODE: {
                    builder.transaction().transactionMode(TransactionMode.valueOf(value));
                    transactionModeSpecified = true;
                    continue block18;
                }
                case USE_EAGER_LOCKING: {
                    builder.transaction().useEagerLocking(Boolean.parseBoolean(value));
                    continue block18;
                }
                case USE_SYNCHRONIZAION: {
                    builder.transaction().useSynchronization(Boolean.parseBoolean(value));
                    continue block18;
                }
                case USE_1PC_FOR_AUTOCOMMIT_TX: {
                    builder.transaction().use1PcForAutoCommitTransactions(Boolean.parseBoolean(value));
                    continue block18;
                }
                case REAPER_WAKE_UP_INTERVAL: {
                    builder.transaction().reaperWakeUpInterval(Long.parseLong(value));
                    continue block18;
                }
                case COMPLETED_TX_TIMEOUT: {
                    builder.transaction().completedTxTimeout(Long.parseLong(value));
                    continue block18;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (!transactionModeSpecified && forceSetTransactional) {
            builder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        }
        block19: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case RECOVERY: {
                    this.parseRecovery(reader, holder);
                    continue block19;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseRecovery(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        RecoveryConfigurationBuilder recovery = holder.getCurrentConfigurationBuilder().transaction().recovery();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        recovery.enable();
                        continue block4;
                    }
                    recovery.disable();
                    continue block4;
                }
                case RECOVERY_INFO_CACHE_NAME: {
                    recovery.recoveryInfoCacheName(value);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseUnsafe(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case UNRELIABLE_RETURN_VALUES: {
                    builder.unsafe().unreliableReturnValues(Boolean.parseBoolean(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStoreAsBinary(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.storeAsBinary().enable();
                        continue block5;
                    }
                    builder.storeAsBinary().disable();
                    continue block5;
                }
                case STORE_KEYS_AS_BINARY: {
                    builder.storeAsBinary().storeKeysAsBinary(Boolean.parseBoolean(value));
                    continue block5;
                }
                case STORE_VALUES_AS_BINARY: {
                    builder.storeAsBinary().storeValuesAsBinary(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLocking(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CONCURRENCY_LEVEL: {
                    builder.locking().concurrencyLevel(Integer.parseInt(value));
                    continue block8;
                }
                case ISOLATION_LEVEL: {
                    builder.locking().isolationLevel(IsolationLevel.valueOf(value));
                    continue block8;
                }
                case LOCK_ACQUISITION_TIMEOUT: {
                    builder.locking().lockAcquisitionTimeout(Long.parseLong(value));
                    continue block8;
                }
                case USE_LOCK_STRIPING: {
                    builder.locking().useLockStriping(Boolean.parseBoolean(value));
                    continue block8;
                }
                case WRITE_SKEW_CHECK: {
                    builder.locking().writeSkewCheck(Boolean.parseBoolean(value));
                    continue block8;
                }
                case SUPPORTS_CONCURRENT_UPDATES: {
                    builder.locking().supportsConcurrentUpdates(Boolean.parseBoolean(value));
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseLoaders(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block11: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case PASSIVATION: {
                    builder.loaders().passivation(Boolean.parseBoolean(value));
                    continue block11;
                }
                case PRELOAD: {
                    builder.loaders().preload(Boolean.parseBoolean(value));
                    continue block11;
                }
                case SHARED: {
                    builder.loaders().shared(Boolean.parseBoolean(value));
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case CLUSTER_LOADER: {
                    this.parseClusterLoader(reader, holder);
                    continue block12;
                }
                case FILE_STORE: {
                    this.parseFileStore(reader, holder);
                    continue block12;
                }
                case LOADER: {
                    this.parseLoader(reader, holder);
                    continue block12;
                }
                case STORE: {
                    this.parseStore(reader, holder);
                    continue block12;
                }
            }
            reader.handleAny(holder);
        }
    }

    private void parseClusterLoader(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ClusterCacheLoaderConfigurationBuilder cclb = builder.loaders().addClusterCacheLoader();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REMOTE_CALL_TIMEOUT: {
                    cclb.remoteCallTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    Parser52.parseCommonLoaderAttributes(reader, i, cclb);
                }
            }
        }
        this.parseLoaderChildren(reader, cclb);
    }

    private void parseFileStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        FileCacheStoreConfigurationBuilder fcscb = builder.loaders().addFileCacheStore();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LOCATION: {
                    fcscb.location(value);
                    continue block6;
                }
                case FSYNC_INTERVAL: {
                    fcscb.fsyncInterval(Long.parseLong(value));
                    continue block6;
                }
                case FSYNC_MODE: {
                    fcscb.fsyncMode(FileCacheStoreConfigurationBuilder.FsyncMode.valueOf(value));
                    continue block6;
                }
                case STREAM_BUFFER_SIZE: {
                    fcscb.streamBufferSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    Parser52.parseLockSupportStoreAttributes(reader, i, fcscb);
                }
            }
        }
        this.parseStoreChildren(reader, fcscb);
    }

    public static void parseLockSupportStoreAttributes(XMLExtendedStreamReader reader, int i, LockSupportStoreConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        ParseUtils.requireNoNamespaceAttribute(reader, i);
        String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
        switch (attribute) {
            case LOCK_ACQUISITION_TIMEOUT: {
                builder.lockAcquistionTimeout(Long.parseLong(value));
                break;
            }
            case CONCURRENCY_LEVEL: {
                builder.lockConcurrencyLevel(Integer.parseInt(value));
                break;
            }
            default: {
                Parser52.parseCommonStoreAttributes(reader, i, builder);
            }
        }
    }

    public static void parseCommonLoaderAttributes(XMLExtendedStreamReader reader, int i, CacheLoaderConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        throw ParseUtils.unexpectedAttribute(reader, i);
    }

    public static void parseCommonStoreAttributes(XMLExtendedStreamReader reader, int i, CacheStoreConfigurationBuilder<?, ?> builder) throws XMLStreamException {
        ParseUtils.requireNoNamespaceAttribute(reader, i);
        String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
        switch (attribute) {
            case FETCH_PERSISTENT_STATE: {
                builder.fetchPersistentState(Boolean.parseBoolean(value));
                break;
            }
            case IGNORE_MODIFICATIONS: {
                builder.ignoreModifications(Boolean.parseBoolean(value));
                break;
            }
            case PURGE_ON_STARTUP: {
                builder.purgeOnStartup(Boolean.parseBoolean(value));
                break;
            }
            case PURGE_SYNCHRONOUSLY: {
                builder.purgeSynchronously(Boolean.parseBoolean(value));
                break;
            }
            case PURGER_THREADS: {
                builder.purgerThreads(Integer.parseInt(value));
                break;
            }
            default: {
                throw ParseUtils.unexpectedAttribute(reader, i);
            }
        }
    }

    private void parseLoader(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        CacheLoader loader = null;
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Integer purgerThreads = null;
        Boolean purgeSynchronously = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    loader = (CacheLoader)Util.getInstance(value, holder.getClassLoader());
                    continue block8;
                }
                case FETCH_PERSISTENT_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block8;
                }
                case IGNORE_MODIFICATIONS: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGE_ON_STARTUP: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGER_THREADS: {
                    purgerThreads = Integer.valueOf(value);
                    continue block8;
                }
                case PURGE_SYNCHRONOUSLY: {
                    purgeSynchronously = Boolean.valueOf(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (loader != null) {
            if (loader instanceof FileCacheStore) {
                FileCacheStoreConfigurationBuilder fcscb = builder.loaders().addFileCacheStore();
                if (fetchPersistentState != null) {
                    fcscb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    fcscb.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    fcscb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    fcscb.purgeSynchronously(purgeSynchronously);
                }
                this.parseStoreChildren(reader, fcscb);
            } else if (loader instanceof CacheStore) {
                log.deprecatedLoaderAsStoreConfiguration();
                LegacyStoreConfigurationBuilder scb = builder.loaders().addStore();
                scb.cacheStore((CacheStore)loader);
                if (fetchPersistentState != null) {
                    scb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    scb.ignoreModifications(ignoreModifications);
                }
                if (purgerThreads != null) {
                    scb.purgerThreads(purgerThreads);
                }
                if (purgeOnStartup != null) {
                    scb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    scb.purgeSynchronously(purgeSynchronously);
                }
                this.parseStoreChildren(reader, scb);
            } else if (loader instanceof ClusterCacheLoader) {
                ClusterCacheLoaderConfigurationBuilder cclb = builder.loaders().addClusterCacheLoader();
                this.parseLoaderChildren(reader, cclb);
            } else {
                LegacyLoaderConfigurationBuilder lcb = builder.loaders().addLoader();
                lcb.cacheLoader(loader);
                this.parseLoaderChildren(reader, lcb);
            }
        }
    }

    private void parseStore(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        CacheStore store = null;
        Boolean fetchPersistentState = null;
        Boolean ignoreModifications = null;
        Boolean purgeOnStartup = null;
        Integer purgerThreads = null;
        Boolean purgeSynchronously = null;
        block8: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    store = (CacheStore)Util.getInstance(value, holder.getClassLoader());
                    continue block8;
                }
                case FETCH_PERSISTENT_STATE: {
                    fetchPersistentState = Boolean.valueOf(value);
                    continue block8;
                }
                case IGNORE_MODIFICATIONS: {
                    ignoreModifications = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGE_ON_STARTUP: {
                    purgeOnStartup = Boolean.valueOf(value);
                    continue block8;
                }
                case PURGER_THREADS: {
                    purgerThreads = Integer.valueOf(value);
                    continue block8;
                }
                case PURGE_SYNCHRONOUSLY: {
                    purgeSynchronously = Boolean.valueOf(value);
                    continue block8;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        if (store != null) {
            if (store instanceof FileCacheStore) {
                FileCacheStoreConfigurationBuilder fcscb = builder.loaders().addFileCacheStore();
                if (fetchPersistentState != null) {
                    fcscb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    fcscb.ignoreModifications(ignoreModifications);
                }
                if (purgeOnStartup != null) {
                    fcscb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    fcscb.purgeSynchronously(purgeSynchronously);
                }
                this.parseStoreChildren(reader, fcscb);
            } else {
                LegacyStoreConfigurationBuilder scb = builder.loaders().addStore();
                scb.cacheStore(store);
                if (fetchPersistentState != null) {
                    scb.fetchPersistentState(fetchPersistentState);
                }
                if (ignoreModifications != null) {
                    scb.ignoreModifications(ignoreModifications);
                }
                if (purgerThreads != null) {
                    scb.purgerThreads(purgerThreads);
                }
                if (purgeOnStartup != null) {
                    scb.purgeOnStartup(purgeOnStartup);
                }
                if (purgeSynchronously != null) {
                    scb.purgeSynchronously(purgeSynchronously);
                }
                this.parseStoreChildren(reader, scb);
            }
        }
    }

    private void parseLoaderChildren(XMLExtendedStreamReader reader, CacheLoaderConfigurationBuilder<?, ?> loaderBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser52.parseCommonLoaderChildren(reader, loaderBuilder);
        }
    }

    public static void parseCommonLoaderChildren(XMLExtendedStreamReader reader, CacheLoaderConfigurationBuilder<?, ?> loaderBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case PROPERTIES: {
                loaderBuilder.withProperties(Parser52.parseProperties(reader));
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    private void parseStoreChildren(XMLExtendedStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            Parser52.parseCommonStoreChildren(reader, storeBuilder);
        }
    }

    public static void parseCommonStoreChildren(XMLExtendedStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        switch (element) {
            case ASYNC: {
                Parser52.parseAsyncStore(reader, storeBuilder);
                break;
            }
            case PROPERTIES: {
                storeBuilder.withProperties(Parser52.parseProperties(reader));
                break;
            }
            case SINGLETON_STORE: {
                Parser52.parseSingletonStore(reader, storeBuilder);
                break;
            }
            default: {
                throw ParseUtils.unexpectedElement(reader);
            }
        }
    }

    public static void parseSingletonStore(XMLExtendedStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        storeBuilder.singletonStore().enable();
                        continue block5;
                    }
                    storeBuilder.singletonStore().disable();
                    continue block5;
                }
                case PUSH_STATE_TIMEOUT: {
                    storeBuilder.singletonStore().pushStateTimeout(Long.parseLong(value));
                    continue block5;
                }
                case PUSH_STATE_WHEN_COORDINATOR: {
                    storeBuilder.singletonStore().pushStateWhenCoordinator(Boolean.parseBoolean(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    public static void parseAsyncStore(XMLExtendedStreamReader reader, CacheStoreConfigurationBuilder<?, ?> storeBuilder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        storeBuilder.async().enable();
                        continue block7;
                    }
                    storeBuilder.async().disable();
                    continue block7;
                }
                case FLUSH_LOCK_TIMEOUT: {
                    storeBuilder.async().flushLockTimeout(Long.parseLong(value));
                    continue block7;
                }
                case MODIFICATION_QUEUE_SIZE: {
                    storeBuilder.async().modificationQueueSize(Integer.parseInt(value));
                    continue block7;
                }
                case SHUTDOWN_TIMEOUT: {
                    storeBuilder.async().shutdownTimeout(Long.parseLong(value));
                    continue block7;
                }
                case THREAD_POOL_SIZE: {
                    storeBuilder.async().threadPoolSize(Integer.parseInt(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseJmxStatistics(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.jmxStatistics().enable();
                        continue block3;
                    }
                    builder.jmxStatistics().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseInvocationBatching(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.invocationBatching().enable();
                        continue block3;
                    }
                    builder.invocationBatching().disable();
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseIndexing(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.indexing().enable();
                        continue block7;
                    }
                    builder.indexing().disable();
                    continue block7;
                }
                case INDEX_LOCAL_ONLY: {
                    builder.indexing().indexLocalOnly(Boolean.parseBoolean(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        Properties indexingProperties = null;
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    indexingProperties = Parser52.parseProperties(reader);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        IndexingConfigurationBuilder indexing = builder.indexing();
        if (indexingProperties != null) {
            indexing.withProperties(indexingProperties);
        }
    }

    private void parseExpiration(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case LIFESPAN: {
                    builder.expiration().lifespan(Long.parseLong(value));
                    continue block6;
                }
                case MAX_IDLE: {
                    builder.expiration().maxIdle(Long.parseLong(value));
                    continue block6;
                }
                case REAPER_ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.expiration().enableReaper();
                        continue block6;
                    }
                    builder.expiration().disableReaper();
                    continue block6;
                }
                case WAKE_UP_INTERVAL: {
                    builder.expiration().wakeUpInterval(Long.parseLong(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseEviction(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block5: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MAX_ENTRIES: {
                    builder.eviction().maxEntries(Integer.parseInt(value));
                    continue block5;
                }
                case STRATEGY: {
                    builder.eviction().strategy(EvictionStrategy.valueOf(value));
                    continue block5;
                }
                case THREAD_POLICY: {
                    builder.eviction().threadPolicy(EvictionThreadPolicy.valueOf(value));
                    continue block5;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDeadlockDetection(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block4: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.deadlockDetection().enable();
                        continue block4;
                    }
                    builder.deadlockDetection().disable();
                    continue block4;
                }
                case SPIN_DURATION: {
                    builder.deadlockDetection().spinDuration(Long.parseLong(value));
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseDataContainer(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLASS: {
                    builder.dataContainer().dataContainer((DataContainer)Util.getInstance(value, holder.getClassLoader()));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.dataContainer().withProperties(Parser52.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseCustomInterceptors(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        block3: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case INTERCEPTOR: {
                    this.parseInterceptor(reader, holder);
                    continue block3;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseInterceptor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        InterceptorConfigurationBuilder interceptorBuilder = builder.customInterceptors().addInterceptor();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case AFTER: {
                    interceptorBuilder.after(Util.loadClass(value, holder.getClassLoader()));
                    continue block10;
                }
                case BEFORE: {
                    interceptorBuilder.before(Util.loadClass(value, holder.getClassLoader()));
                    continue block10;
                }
                case CLASS: {
                    interceptorBuilder.interceptor((CommandInterceptor)Util.getInstance(value, holder.getClassLoader()));
                    continue block10;
                }
                case INDEX: {
                    interceptorBuilder.index(Integer.parseInt(value));
                    continue block10;
                }
                case POSITION: {
                    interceptorBuilder.position(InterceptorConfiguration.Position.valueOf(value.toUpperCase()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    interceptorBuilder.withProperties(Parser52.parseProperties(reader));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseClustering(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        String clusteringMode = null;
        boolean synchronous = false;
        boolean asynchronous = false;
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MODE: {
                    clusteringMode = value;
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC: {
                    asynchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseAsync(reader, holder);
                    continue block11;
                }
                case HASH: {
                    this.parseHash(reader, holder);
                    continue block11;
                }
                case L1: {
                    this.parseL1reader(reader, holder.getCurrentConfigurationBuilder());
                    continue block11;
                }
                case STATE_TRANSFER: {
                    this.parseStateTransfer(reader, holder.getCurrentConfigurationBuilder());
                    continue block11;
                }
                case SYNC: {
                    synchronous = true;
                    this.setMode(builder, clusteringMode, asynchronous, synchronous, reader);
                    this.parseSync(reader, builder);
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!synchronous && !asynchronous) {
            this.setMode(builder, clusteringMode, asynchronous, asynchronous, reader);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setMode(ConfigurationBuilder builder, String clusteringMode, boolean asynchronous, boolean synchronous, XMLExtendedStreamReader reader) {
        if (synchronous && asynchronous) {
            throw new CacheConfigurationException("Cannot configure <sync> and <async> on the same cluster, " + reader.getLocation());
        }
        if (clusteringMode != null) {
            String mode = clusteringMode.toUpperCase();
            if (ParsedCacheMode.REPL.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.REPL_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.REPL_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.INVALIDATION.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.INVALIDATION_ASYNC);
                }
                return;
            } else if (ParsedCacheMode.DIST.matches(mode)) {
                if (!asynchronous) {
                    builder.clustering().cacheMode(CacheMode.DIST_SYNC);
                    return;
                } else {
                    builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
                }
                return;
            } else {
                if (!ParsedCacheMode.LOCAL.matches(mode)) throw new CacheConfigurationException("Invalid clustering mode " + clusteringMode + ", " + reader.getLocation());
                builder.clustering().cacheMode(CacheMode.LOCAL);
            }
            return;
        } else if (synchronous) {
            builder.clustering().cacheMode(CacheMode.DIST_SYNC);
            return;
        } else {
            if (!asynchronous) return;
            builder.clustering().cacheMode(CacheMode.DIST_ASYNC);
        }
    }

    private void parseSync(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case REPL_TIMEOUT: {
                    builder.clustering().sync().replTimeout(Long.parseLong(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseStateTransfer(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FETCH_IN_MEMORY_STATE: {
                    builder.clustering().stateTransfer().fetchInMemoryState(Boolean.parseBoolean(value));
                    continue block6;
                }
                case AWAIT_INITIAL_TRANSFER: {
                    builder.clustering().stateTransfer().awaitInitialTransfer(Boolean.parseBoolean(value));
                    continue block6;
                }
                case TIMEOUT: {
                    builder.clustering().stateTransfer().timeout(Long.parseLong(value));
                    continue block6;
                }
                case CHUNK_SIZE: {
                    builder.clustering().stateTransfer().chunkSize(Integer.parseInt(value));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseL1reader(XMLExtendedStreamReader reader, ConfigurationBuilder builder) throws XMLStreamException {
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().l1().enable();
                        continue block7;
                    }
                    builder.clustering().l1().disable();
                    continue block7;
                }
                case INVALIDATION_THRESHOLD: {
                    builder.clustering().l1().invalidationThreshold(Integer.parseInt(value));
                    continue block7;
                }
                case LIFESPAN: {
                    builder.clustering().l1().lifespan(Long.parseLong(value));
                    continue block7;
                }
                case INVALIDATION_CLEANUP_TASK_FREQUENCY: {
                    builder.clustering().l1().cleanupTaskFrequency(Long.parseLong(value));
                    continue block7;
                }
                case ON_REHASH: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().l1().enableOnRehash();
                        continue block7;
                    }
                    builder.clustering().l1().disableOnRehash();
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseHash(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block9: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.clustering().hash().consistentHashFactory((ConsistentHashFactory)Util.getInstance(value, holder.getClassLoader()));
                    continue block9;
                }
                case HASH_FUNCTION_CLASS: {
                    builder.clustering().hash().hash((Hash)Util.getInstance(value, holder.getClassLoader()));
                    continue block9;
                }
                case NUM_OWNERS: {
                    builder.clustering().hash().numOwners(Integer.parseInt(value));
                    continue block9;
                }
                case NUM_SEGMENTS: {
                    builder.clustering().hash().numSegments(Integer.parseInt(value));
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPS: {
                    this.parseGroups(reader, holder);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGroups(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        String value;
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        ParseUtils.requireSingleAttribute(reader, "enabled");
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ENABLED: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().hash().groups().enabled();
                        continue block6;
                    }
                    builder.clustering().hash().groups().disabled();
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case GROUPER: {
                    value = ParseUtils.readStringAttributeElement(reader, "class");
                    builder.clustering().hash().groups().addGrouper((Grouper)Util.getInstance(value, holder.getClassLoader()));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsync(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        ConfigurationBuilder builder = holder.getCurrentConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ASYNC_MARSHALLING: {
                    if (Boolean.parseBoolean(value)) {
                        builder.clustering().async().asyncMarshalling();
                        continue block7;
                    }
                    builder.clustering().async().syncMarshalling();
                    continue block7;
                }
                case REPL_QUEUE_CLASS: {
                    builder.clustering().async().replQueue((ReplicationQueue)Util.getInstance(value, holder.getClassLoader()));
                    continue block7;
                }
                case REPL_QUEUE_INTERVAL: {
                    builder.clustering().async().replQueueInterval(Long.parseLong(value));
                    continue block7;
                }
                case REPL_QUEUE_MAX_ELEMENTS: {
                    builder.clustering().async().replQueueMaxElements(Integer.parseInt(value));
                    continue block7;
                }
                case USE_REPL_QUEUE: {
                    builder.clustering().async().useReplQueue(Boolean.parseBoolean(value));
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseGlobal(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        ParseUtils.requireNoAttributes(reader);
        boolean transportParsed = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ASYNC_LISTENER_EXECUTOR: {
                    this.parseAsyncListenerExecutor(reader, holder);
                    continue block12;
                }
                case ASYNC_TRANSPORT_EXECUTOR: {
                    this.parseAsyncTransportExecutor(reader, holder);
                    continue block12;
                }
                case EVICTION_SCHEDULED_EXECUTOR: {
                    this.parseEvictionScheduledExecutor(reader, holder);
                    continue block12;
                }
                case GLOBAL_JMX_STATISTICS: {
                    this.parseGlobalJMXStatistics(reader, holder);
                    continue block12;
                }
                case MODULES: {
                    this.parseModules(reader, holder);
                    continue block12;
                }
                case REPLICATION_QUEUE_SCHEDULED_EXECUTOR: {
                    this.parseReplicationQueueScheduledExecutor(reader, holder);
                    continue block12;
                }
                case SERIALIZATION: {
                    this.parseSerialization(reader, holder);
                    continue block12;
                }
                case SHUTDOWN: {
                    this.parseShutdown(reader, holder);
                    continue block12;
                }
                case TRANSPORT: {
                    this.parseTransport(reader, holder);
                    transportParsed = true;
                    continue block12;
                }
                case SITE: {
                    this.parseGlobalSites(reader, holder);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        if (!transportParsed) {
            builder.transport().transport(null);
        } else if (builder.transport().getTransport() == null) {
            builder.transport().defaultTransport();
        }
    }

    private void parseTransport(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block13: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case CLUSTER_NAME: {
                    builder.transport().clusterName(value);
                    continue block13;
                }
                case DISTRIBUTED_SYNC_TIMEOUT: {
                    builder.transport().distributedSyncTimeout(Long.parseLong(value));
                    continue block13;
                }
                case MACHINE_ID: {
                    builder.transport().machineId(value);
                    continue block13;
                }
                case NODE_NAME: {
                    builder.transport().nodeName(value);
                    continue block13;
                }
                case RACK_ID: {
                    builder.transport().rackId(value);
                    continue block13;
                }
                case SITE_ID: {
                    builder.transport().siteId(value);
                    continue block13;
                }
                case STRICT_PEER_TO_PEER: {
                    builder.transport().strictPeerToPeer(Boolean.valueOf(value));
                    continue block13;
                }
                case TRANSPORT_CLASS: {
                    builder.transport().transport((Transport)Util.getInstance(value, holder.getClassLoader()));
                    continue block13;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block14: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.transport().withProperties(Parser52.parseProperties(reader));
                    continue block14;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseShutdown(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block3: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case HOOK_BEHAVIOR: {
                    builder.shutdown().hookBehavior(ShutdownHookBehavior.valueOf(value));
                    continue block3;
                }
                default: {
                    throw ParseUtils.unexpectedElement(reader);
                }
            }
        }
        ParseUtils.requireNoContent(reader);
    }

    private void parseSerialization(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block7: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case MARSHALLER_CLASS: {
                    builder.serialization().marshaller((Marshaller)Util.getInstance(value, holder.getClassLoader()));
                    continue block7;
                }
                case VERSION: {
                    builder.serialization().version(value);
                    continue block7;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block8: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZERS: {
                    this.parseAdvancedExternalizers(reader, holder);
                    continue block8;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAdvancedExternalizers(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        ParseUtils.requireNoAttributes(reader);
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case ADVANCED_EXTERNALIZER: {
                    int attributes = reader.getAttributeCount();
                    AdvancedExternalizer advancedExternalizer = null;
                    Integer id = null;
                    ParseUtils.requireAttributes(reader, Attribute.EXTERNALIZER_CLASS.getLocalName());
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case EXTERNALIZER_CLASS: {
                                advancedExternalizer = (AdvancedExternalizer)Util.getInstance(value, holder.getClassLoader());
                                continue block8;
                            }
                            case ID: {
                                id = Integer.valueOf(value);
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    ParseUtils.requireNoContent(reader);
                    if (id != null) {
                        builder.serialization().addAdvancedExternalizer((int)id, advancedExternalizer);
                        continue block7;
                    }
                    builder.serialization().addAdvancedExternalizer(advancedExternalizer);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseReplicationQueueScheduledExecutor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.replicationQueueScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance(value, holder.getClassLoader()));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.replicationQueueScheduledExecutor().withProperties(Parser52.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseGlobalJMXStatistics(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block10: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case ALLOW_DUPLICATE_DOMAINS: {
                    builder.globalJmxStatistics().allowDuplicateDomains(Boolean.valueOf(value));
                    continue block10;
                }
                case CACHE_MANAGER_NAME: {
                    builder.globalJmxStatistics().cacheManagerName(value);
                    continue block10;
                }
                case ENABLED: {
                    if (!Boolean.parseBoolean(value)) {
                        builder.globalJmxStatistics().disable();
                        continue block10;
                    }
                    builder.globalJmxStatistics().enable();
                    continue block10;
                }
                case JMX_DOMAIN: {
                    builder.globalJmxStatistics().jmxDomain(value);
                    continue block10;
                }
                case MBEAN_SERVER_LOOKUP: {
                    builder.globalJmxStatistics().mBeanServerLookup((MBeanServerLookup)Util.getInstance(value, holder.getClassLoader()));
                    continue block10;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block11: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.globalJmxStatistics().withProperties(Parser52.parseProperties(reader));
                    continue block11;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseEvictionScheduledExecutor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.evictionScheduledExecutor().factory((ScheduledExecutorFactory)Util.getInstance(value, holder.getClassLoader()));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.evictionScheduledExecutor().withProperties(Parser52.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsyncTransportExecutor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.asyncTransportExecutor().factory((ExecutorFactory)Util.getInstance(value, holder.getClassLoader()));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.asyncTransportExecutor().withProperties(Parser52.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    private void parseAsyncListenerExecutor(XMLExtendedStreamReader reader, ConfigurationBuilderHolder holder) throws XMLStreamException {
        GlobalConfigurationBuilder builder = holder.getGlobalConfigurationBuilder();
        block6: for (int i = 0; i < reader.getAttributeCount(); ++i) {
            ParseUtils.requireNoNamespaceAttribute(reader, i);
            String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case FACTORY: {
                    builder.asyncListenerExecutor().factory((ExecutorFactory)Util.getInstance(value, holder.getClassLoader()));
                    continue block6;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute(reader, i);
                }
            }
        }
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTIES: {
                    builder.asyncListenerExecutor().withProperties(Parser52.parseProperties(reader));
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
    }

    public static Properties parseProperties(XMLExtendedStreamReader reader) throws XMLStreamException {
        ParseUtils.requireNoAttributes(reader);
        Properties p = new Properties();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = Element.forName(reader.getLocalName());
            switch (element) {
                case PROPERTY: {
                    int attributes = reader.getAttributeCount();
                    ParseUtils.requireAttributes(reader, Attribute.NAME.getLocalName(), Attribute.VALUE.getLocalName());
                    String key = null;
                    String propertyValue = null;
                    block8: for (int i = 0; i < attributes; ++i) {
                        String value = StringPropertyReplacer.replaceProperties(reader.getAttributeValue(i));
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                key = value;
                                continue block8;
                            }
                            case VALUE: {
                                propertyValue = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute(reader, i);
                            }
                        }
                    }
                    p.put(key, propertyValue);
                    ParseUtils.requireNoContent(reader);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement(reader);
        }
        return p;
    }
}

