/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.distexec.mapreduce;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.commands.CancelCommand;
import org.infinispan.commands.CancellationService;
import org.infinispan.commands.CommandsFactory;
import org.infinispan.commands.CreateCacheCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.read.MapCombineCommand;
import org.infinispan.commands.read.ReduceCommand;
import org.infinispan.commons.CacheException;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Util;
import org.infinispan.commons.util.concurrent.AbstractInProcessFuture;
import org.infinispan.commons.util.concurrent.FutureListener;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.commons.util.concurrent.NotifyingNotifiableFuture;
import org.infinispan.distexec.mapreduce.Collator;
import org.infinispan.distexec.mapreduce.MapReduceManager;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.distexec.mapreduce.spi.MapReduceTaskLifecycleService;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.remoting.responses.Response;
import org.infinispan.remoting.responses.SuccessfulResponse;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.remoting.rpc.RpcOptionsBuilder;
import org.infinispan.remoting.transport.Address;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class MapReduceTask<KIn, VIn, KOut, VOut> {
    private static final Log log = LogFactory.getLog(MapReduceTask.class);
    public static final String DEFAULT_TMP_CACHE_CONFIGURATION_NAME = "__tmpMapReduce";
    protected Mapper<KIn, VIn, KOut, VOut> mapper;
    protected Reducer<KOut, VOut> reducer;
    protected Reducer<KOut, VOut> combiner;
    protected final boolean distributeReducePhase;
    protected final boolean useIntermediateSharedCache;
    protected final Collection<KIn> keys;
    protected final AdvancedCache<KIn, VIn> cache;
    protected final Marshaller marshaller;
    protected final MapReduceManager mapReduceManager;
    protected final CancellationService cancellationService;
    protected final List<CancellableTaskPart> cancellableTasks;
    protected final UUID taskId;
    protected final ClusteringDependentLogic clusteringDependentLogic;
    protected final boolean isLocalOnly;
    protected RpcOptionsBuilder rpcOptionsBuilder;

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode) {
        this(masterCacheNode, false, false);
    }

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode, boolean distributeReducePhase) {
        this(masterCacheNode, distributeReducePhase, true);
    }

    public MapReduceTask(Cache<KIn, VIn> masterCacheNode, boolean distributeReducePhase, boolean useIntermediateSharedCache) {
        if (masterCacheNode == null) {
            throw new IllegalArgumentException("Can not use null cache for MapReduceTask");
        }
        this.ensureProperCacheState(masterCacheNode.getAdvancedCache());
        this.cache = masterCacheNode.getAdvancedCache();
        this.keys = new LinkedList<KIn>();
        this.marshaller = this.cache.getComponentRegistry().getComponent(StreamingMarshaller.class, "org.infinispan.marshaller.cache");
        this.mapReduceManager = this.cache.getComponentRegistry().getComponent(MapReduceManager.class);
        this.cancellationService = this.cache.getComponentRegistry().getComponent(CancellationService.class);
        this.taskId = UUID.randomUUID();
        this.distributeReducePhase = distributeReducePhase;
        this.useIntermediateSharedCache = useIntermediateSharedCache;
        this.cancellableTasks = Collections.synchronizedList(new ArrayList());
        this.clusteringDependentLogic = this.cache.getComponentRegistry().getComponent(ClusteringDependentLogic.class);
        this.isLocalOnly = this.cache.getRpcManager() == null;
        this.rpcOptionsBuilder = this.isLocalOnly ? null : new RpcOptionsBuilder(this.cache.getRpcManager().getDefaultRpcOptions(true));
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> onKeys(KIn ... input) {
        Collections.addAll(this.keys, input);
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> mappedWith(Mapper<KIn, VIn, KOut, VOut> mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("A valid reference of Mapper is needed");
        }
        this.mapper = mapper;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> reducedWith(Reducer<KOut, VOut> reducer) {
        if (reducer == null) {
            throw new IllegalArgumentException("A valid reference of Reducer is needed");
        }
        this.reducer = reducer;
        return this;
    }

    public MapReduceTask<KIn, VIn, KOut, VOut> combinedWith(Reducer<KOut, VOut> combiner) {
        if (combiner == null) {
            throw new IllegalArgumentException("A valid reference of Reducer/Combiner is needed");
        }
        this.combiner = combiner;
        return this;
    }

    public final MapReduceTask<KIn, VIn, KOut, VOut> timeout(long timeout, TimeUnit unit) {
        this.rpcOptionsBuilder.timeout(timeout, unit);
        return this;
    }

    public final long timeout(TimeUnit outputTimeUnit) {
        return this.rpcOptionsBuilder.timeout(outputTimeUnit);
    }

    public Map<KOut, VOut> execute() throws CacheException {
        if (this.mapper == null) {
            throw new NullPointerException("A valid reference of Mapper is not set " + this.mapper);
        }
        if (this.reducer == null) {
            throw new NullPointerException("A valid reference of Reducer is not set " + this.reducer);
        }
        if (!this.isLocalOnly && this.distributeReducePhase()) {
            boolean useCompositeKeys = this.useIntermediateSharedCache();
            String intermediateCacheName = DEFAULT_TMP_CACHE_CONFIGURATION_NAME;
            if (this.useIntermediatePerTaskCache()) {
                intermediateCacheName = this.taskId.toString();
            }
            try {
                this.executeTaskInit(intermediateCacheName);
                Set<KOut> allMapPhasesResponses = this.executeMapPhase(useCompositeKeys);
                Map<KOut, VOut> map = this.executeReducePhase(allMapPhasesResponses, useCompositeKeys);
                return map;
            }
            catch (Exception cause) {
                throw new CacheException(cause);
            }
            finally {
                if (this.useIntermediatePerTaskCache()) {
                    EmbeddedCacheManager cm = this.cache.getCacheManager();
                    cm.removeCache(intermediateCacheName);
                }
            }
        }
        try {
            return this.executeMapPhaseWithLocalReduction();
        }
        catch (Exception cause) {
            throw new CacheException(cause);
        }
    }

    protected boolean distributeReducePhase() {
        return this.distributeReducePhase;
    }

    protected boolean useIntermediateSharedCache() {
        return this.useIntermediateSharedCache;
    }

    protected boolean useIntermediatePerTaskCache() {
        return !this.useIntermediateSharedCache();
    }

    protected void executeTaskInit(String tmpCacheName) {
        RpcManager rpc = this.cache.getRpcManager();
        CommandsFactory factory = this.cache.getComponentRegistry().getComponent(CommandsFactory.class);
        final CreateCacheCommand ccc = factory.buildCreateCacheCommand(tmpCacheName, DEFAULT_TMP_CACHE_CONFIGURATION_NAME, true, rpc.getMembers().size());
        log.debugf("Invoking %s across members %s ", ccc, this.cache.getRpcManager().getMembers());
        this.mapReduceManager.getExecutorService().submit(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                ccc.init(MapReduceTask.this.cache.getCacheManager());
                try {
                    return ccc.perform(null);
                }
                catch (Throwable e) {
                    throw new CacheException("Could not initialize temporary caches for MapReduce task on remote nodes ", e);
                }
            }
        });
        rpc.invokeRemotely(this.cache.getRpcManager().getMembers(), (ReplicableCommand)ccc, this.rpcOptionsBuilder.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Set<KOut> executeMapPhase(boolean useCompositeKeys) throws InterruptedException, ExecutionException {
        RpcManager rpc = this.cache.getRpcManager();
        MapCombineCommand<KIn, VIn, KOut, VOut> cmd = null;
        HashSet mapPhasesResult = new HashSet();
        ArrayList futures = new ArrayList();
        if (this.inputTaskKeysEmpty()) {
            for (Address address : rpc.getMembers()) {
                cmd = address.equals(rpc.getAddress()) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), null, true, useCompositeKeys) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, null, true, useCompositeKeys);
                MapTaskPart part = this.createTaskMapPart(cmd, address, true);
                part.execute();
                futures.add(part);
            }
        } else {
            Map<Address, Collection<KIn>> keysToNodes = this.mapKeysToNodes(this.keys);
            for (Map.Entry<Address, Collection<KIn>> e : keysToNodes.entrySet()) {
                Address address = e.getKey();
                Collection<KIn> keys = e.getValue();
                cmd = address.equals(rpc.getAddress()) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), keys, true, useCompositeKeys) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, keys, true, useCompositeKeys);
                MapTaskPart part = this.createTaskMapPart(cmd, address, true);
                part.execute();
                futures.add(part);
            }
        }
        try {
            for (MapTaskPart mapTaskPart : futures) {
                mapPhasesResult.addAll((Collection)mapTaskPart.get());
            }
        }
        finally {
            this.cancellableTasks.clear();
        }
        return mapPhasesResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KOut, VOut> executeMapPhaseWithLocalReduction() throws InterruptedException, ExecutionException {
        RpcManager rpc = this.cache.getRpcManager();
        MapCombineCommand<KIn, VIn, KOut, VOut> cmd = null;
        HashMap mapPhasesResult = new HashMap();
        ArrayList futures = new ArrayList();
        Address localAddress = this.clusteringDependentLogic.getAddress();
        if (this.inputTaskKeysEmpty()) {
            List<Address> targets = this.isLocalOnly ? Collections.singletonList(localAddress) : rpc.getMembers();
            for (Address address : targets) {
                cmd = address.equals(localAddress) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), null, false, false) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, null, false, false);
                MapTaskPart part = this.createTaskMapPart(cmd, address, false);
                part.execute();
                futures.add(part);
            }
        } else {
            Map<Address, Collection<KIn>> keysToNodes = this.mapKeysToNodes(this.keys);
            for (Map.Entry entry : keysToNodes.entrySet()) {
                Address address = (Address)entry.getKey();
                Collection keys = (Collection)entry.getValue();
                cmd = address.equals(localAddress) ? this.buildMapCombineCommand(this.taskId.toString(), this.clone(this.mapper), this.clone(this.combiner), keys, false, false) : this.buildMapCombineCommand(this.taskId.toString(), this.mapper, this.combiner, keys, false, false);
                MapTaskPart part = this.createTaskMapPart(cmd, address, false);
                part.execute();
                futures.add(part);
            }
        }
        HashMap reducedResult = new HashMap();
        try {
            for (MapTaskPart mapTaskPart : futures) {
                this.mergeResponse(mapPhasesResult, (Map)mapTaskPart.get());
            }
        }
        finally {
            this.cancellableTasks.clear();
        }
        MapReduceTaskLifecycleService taskLifecycleService = MapReduceTaskLifecycleService.getInstance();
        log.tracef("For m/r task %s invoking %s locally", this.taskId, this.reducer);
        try {
            taskLifecycleService.onPreExecute(this.reducer, this.cache);
            for (Map.Entry e : mapPhasesResult.entrySet()) {
                reducedResult.put(e.getKey(), this.reducer.reduce(e.getKey(), ((List)e.getValue()).iterator()));
            }
        }
        finally {
            taskLifecycleService.onPostExecute(this.reducer);
        }
        return reducedResult;
    }

    protected <V> MapTaskPart<V> createTaskMapPart(MapCombineCommand<KIn, VIn, KOut, VOut> cmd, Address target, boolean distributedReduce) {
        MapTaskPart mapTaskPart = new MapTaskPart(target, cmd, distributedReduce);
        this.cancellableTasks.add(mapTaskPart);
        return mapTaskPart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<KOut, VOut> executeReducePhase(Set<KOut> allMapPhasesResponses, boolean useCompositeKeys) throws InterruptedException, ExecutionException {
        RpcManager rpc = this.cache.getRpcManager();
        String destCache = null;
        destCache = useCompositeKeys ? DEFAULT_TMP_CACHE_CONFIGURATION_NAME : this.taskId.toString();
        Cache dstCache = this.cache.getCacheManager().getCache(destCache);
        Map<Address, Collection<KOut>> keysToNodes = this.mapKeysToNodes(dstCache.getAdvancedCache().getDistributionManager(), allMapPhasesResponses, useCompositeKeys);
        HashMap reduceResult = new HashMap();
        ArrayList reduceTasks = new ArrayList();
        ReduceCommand<KOut, VOut> reduceCommand = null;
        for (Map.Entry<Address, Collection<KOut>> entry : keysToNodes.entrySet()) {
            Address address = entry.getKey();
            Collection<KOut> keys = entry.getValue();
            reduceCommand = address.equals(rpc.getAddress()) ? this.buildReduceCommand(this.taskId.toString(), destCache, this.clone(this.reducer), keys, useCompositeKeys) : this.buildReduceCommand(this.taskId.toString(), destCache, this.reducer, keys, useCompositeKeys);
            ReduceTaskPart part = this.createReducePart(reduceCommand, address, destCache);
            part.execute();
            reduceTasks.add(part);
        }
        try {
            for (ReduceTaskPart reduceTaskPart : reduceTasks) {
                reduceResult.putAll((Map)reduceTaskPart.get());
            }
        }
        finally {
            this.cancellableTasks.clear();
        }
        return reduceResult;
    }

    protected <V> ReduceTaskPart<V> createReducePart(ReduceCommand<KOut, VOut> cmd, Address target, String destCacheName) {
        ReduceTaskPart part = new ReduceTaskPart(target, cmd, destCacheName);
        this.cancellableTasks.add(part);
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <K, V> void mergeResponse(Map<K, List<V>> result, Map<K, List<V>> m) {
        for (Map.Entry<K, List<V>> entry : m.entrySet()) {
            Map<K, List<List<V>>> map = result;
            synchronized (map) {
                List<V> list = result.get(entry.getKey());
                if (list != null) {
                    list.addAll((Collection)entry.getValue());
                } else {
                    list = new ArrayList<V>();
                    list.addAll((Collection)entry.getValue());
                }
                result.put(entry.getKey(), list);
            }
        }
    }

    private MapCombineCommand<KIn, VIn, KOut, VOut> buildMapCombineCommand(String taskId, Mapper<KIn, VIn, KOut, VOut> m, Reducer<KOut, VOut> r, Collection<KIn> keys, boolean reducePhaseDistributed, boolean emitCompositeIntermediateKeys) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        MapCombineCommand<KIn, VIn, KOut, VOut> c = factory.buildMapCombineCommand(taskId, m, r, keys);
        c.setReducePhaseDistributed(reducePhaseDistributed);
        c.setEmitCompositeIntermediateKeys(emitCompositeIntermediateKeys);
        return c;
    }

    private ReduceCommand<KOut, VOut> buildReduceCommand(String taskId, String destinationCache, Reducer<KOut, VOut> r, Collection<KOut> keys, boolean emitCompositeIntermediateKeys) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        ReduceCommand<KOut, VOut> reduceCommand = factory.buildReduceCommand(taskId, destinationCache, r, keys);
        reduceCommand.setEmitCompositeIntermediateKeys(emitCompositeIntermediateKeys);
        return reduceCommand;
    }

    private CancelCommand buildCancelCommand(CancellableTaskPart taskPart) {
        ComponentRegistry registry = this.cache.getComponentRegistry();
        CommandsFactory factory = registry.getComponent(CommandsFactory.class);
        return factory.buildCancelCommandCommand(taskPart.getUUID());
    }

    public Future<Map<KOut, VOut>> executeAsynchronously() {
        return new MapReduceTaskFuture<Map<KOut, VOut>>(new Callable<Map<KOut, VOut>>(){

            @Override
            public Map<KOut, VOut> call() throws Exception {
                return MapReduceTask.this.execute();
            }
        });
    }

    public <R> R execute(Collator<KOut, VOut, R> collator) {
        Map<KOut, VOut> execute = this.execute();
        return collator.collate(execute);
    }

    public <R> Future<R> executeAsynchronously(final Collator<KOut, VOut, R> collator) {
        return new MapReduceTaskFuture(new Callable<R>(){

            @Override
            public R call() throws Exception {
                return MapReduceTask.this.execute(collator);
            }
        });
    }

    protected void aggregateReducedResult(Map<KOut, List<VOut>> finalReduced, Map<KOut, VOut> mapReceived) {
        for (Map.Entry<KOut, VOut> entry : mapReceived.entrySet()) {
            List<Object> l;
            if (!finalReduced.containsKey(entry.getKey())) {
                l = new LinkedList();
                finalReduced.put(entry.getKey(), l);
            } else {
                l = finalReduced.get(entry.getKey());
            }
            l.add(entry.getValue());
        }
    }

    protected <T> Map<Address, ? extends Collection<T>> mapKeysToNodes(DistributionManager dm, Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        if (this.isLocalOnly) {
            return Collections.singletonMap(this.clusteringDependentLogic.getAddress(), keysToMap);
        }
        return this.mapReduceManager.mapKeysToNodes(dm, this.taskId.toString(), keysToMap, useIntermediateCompositeKey);
    }

    protected <T> Map<Address, ? extends Collection<T>> mapKeysToNodes(Collection<T> keysToMap, boolean useIntermediateCompositeKey) {
        return this.mapKeysToNodes(this.cache.getDistributionManager(), keysToMap, useIntermediateCompositeKey);
    }

    protected <T> Map<Address, ? extends Collection<T>> mapKeysToNodes(Collection<T> keysToMap) {
        return this.mapKeysToNodes(keysToMap, false);
    }

    protected Mapper<KIn, VIn, KOut, VOut> clone(Mapper<KIn, VIn, KOut, VOut> mapper) {
        return Util.cloneWithMarshaller(this.marshaller, mapper);
    }

    protected Reducer<KOut, VOut> clone(Reducer<KOut, VOut> reducer) {
        return Util.cloneWithMarshaller(this.marshaller, reducer);
    }

    private void ensureProperCacheState(AdvancedCache<KIn, VIn> cache) throws NullPointerException, IllegalStateException {
        if (cache.getStatus() != ComponentStatus.RUNNING) {
            throw log.invalidCacheState(cache.getStatus().toString());
        }
        if (cache.getRpcManager() != null && cache.getDistributionManager() == null) {
            throw log.requireDistOrReplCache(cache.getCacheConfiguration().clustering().cacheModeString());
        }
    }

    protected boolean inputTaskKeysEmpty() {
        return this.keys == null || this.keys.isEmpty();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.taskId == null ? 0 : this.taskId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapReduceTask)) {
            return false;
        }
        MapReduceTask other = (MapReduceTask)obj;
        return !(this.taskId == null ? other.taskId != null : !this.taskId.equals(other.taskId));
    }

    public String toString() {
        return "MapReduceTask [mapper=" + this.mapper + ", reducer=" + this.reducer + ", combiner=" + this.combiner + ", keys=" + this.keys + ", taskId=" + this.taskId + "]";
    }

    private static interface CancellableTaskPart {
        public UUID getUUID();

        public Address getExecutionTarget();
    }

    private class ReduceTaskPart<V>
    extends TaskPart<V> {
        private ReduceCommand<KOut, VOut> rc;
        private String cacheName;

        public ReduceTaskPart(Address executionTarget, ReduceCommand<KOut, VOut> command, String destinationCacheName) {
            super(executionTarget);
            this.rc = command;
            this.cacheName = destinationCacheName;
        }

        @Override
        public void execute() {
            if (this.locallyExecuted()) {
                Callable<Map<Address, ? extends Response>> callable = new Callable<Map<Address, ? extends Response>>(){

                    @Override
                    public Map<Address, ? extends Response> call() throws Exception {
                        Cache dstCache = MapReduceTask.this.cache.getCacheManager().getCache(ReduceTaskPart.this.cacheName);
                        Map result = ReduceTaskPart.this.invokeReduceLocally(dstCache);
                        return Collections.singletonMap(ReduceTaskPart.this.getAddress(), SuccessfulResponse.create(result));
                    }
                };
                FutureTask<Map<Address, ? extends Response>> futureTask = new FutureTask<Map<Address, ? extends Response>>(callable);
                this.setNetworkFuture(futureTask);
                MapReduceTask.this.mapReduceManager.getExecutorService().submit(futureTask);
            } else {
                RpcManager rpc = MapReduceTask.this.cache.getRpcManager();
                try {
                    log.debugf("Invoking %s on %s", this.rc, this.getExecutionTarget());
                    rpc.invokeRemotelyInFuture(Collections.singleton(this.getExecutionTarget()), this.rc, MapReduceTask.this.rpcOptionsBuilder.build(), (NotifyingNotifiableFuture<Object>)this);
                    log.debugf("Invoked %s on %s ", this.rc, this.getExecutionTarget());
                }
                catch (Exception ex) {
                    throw new CacheException("Could not invoke map phase of MapReduceTask on remote node " + this.getExecutionTarget(), ex);
                }
            }
        }

        private Map<KOut, VOut> invokeReduceLocally(Cache<Object, Object> dstCache) {
            this.rc.init(MapReduceTask.this.mapReduceManager);
            Map localReduceResult = null;
            try {
                log.debugf("Invoking %s locally ", this.rc);
                localReduceResult = MapReduceTask.this.mapReduceManager.reduce(this.rc);
                log.debugf("Invoked %s locally", this.rc);
            }
            catch (Throwable e1) {
                throw new CacheException("Could not invoke MapReduce task locally ", e1);
            }
            return localReduceResult;
        }

        @Override
        public UUID getUUID() {
            return this.rc.getUUID();
        }
    }

    private class MapTaskPart<V>
    extends TaskPart<V> {
        private MapCombineCommand<KIn, VIn, KOut, VOut> mcc;
        private boolean distributedReduce;

        public MapTaskPart(Address executionTarget, MapCombineCommand<KIn, VIn, KOut, VOut> command, boolean distributedReduce) {
            super(executionTarget);
            this.mcc = command;
            this.distributedReduce = distributedReduce;
        }

        @Override
        public void execute() {
            if (this.locallyExecuted()) {
                Callable<Map<Address, ? extends Response>> callable = this.distributedReduce ? new Callable<Map<Address, ? extends Response>>(){

                    @Override
                    public Map<Address, ? extends Response> call() throws Exception {
                        Set result = MapTaskPart.this.invokeMapCombineLocally();
                        return Collections.singletonMap(MapTaskPart.this.getAddress(), SuccessfulResponse.create(result));
                    }
                } : new Callable<Map<Address, ? extends Response>>(){

                    @Override
                    public Map<Address, ? extends Response> call() throws Exception {
                        Map result = MapTaskPart.this.invokeMapCombineLocallyForLocalReduction();
                        return Collections.singletonMap(MapTaskPart.this.getAddress(), SuccessfulResponse.create(result));
                    }
                };
                FutureTask<Map<Address, ? extends Response>> futureTask = new FutureTask<Map<Address, ? extends Response>>(callable);
                this.setNetworkFuture(futureTask);
                MapReduceTask.this.mapReduceManager.getExecutorService().submit(futureTask);
            } else {
                RpcManager rpc = MapReduceTask.this.cache.getRpcManager();
                try {
                    log.debugf("Invoking %s on %s", this.mcc, this.getExecutionTarget());
                    rpc.invokeRemotelyInFuture(Collections.singleton(this.getExecutionTarget()), this.mcc, MapReduceTask.this.rpcOptionsBuilder.build(), (NotifyingNotifiableFuture<Object>)this);
                    log.debugf("Invoked %s on %s ", this.mcc, this.getExecutionTarget());
                }
                catch (Exception ex) {
                    throw new CacheException("Could not invoke map phase of MapReduceTask on remote node " + this.getExecutionTarget(), ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<KOut, List<VOut>> invokeMapCombineLocallyForLocalReduction() throws InterruptedException {
            log.debugf("Invoking %s locally", this.mcc);
            try {
                MapReduceTask.this.cancellationService.register(Thread.currentThread(), this.mcc.getUUID());
                this.mcc.init(MapReduceTask.this.mapReduceManager);
                Map map = MapReduceTask.this.mapReduceManager.mapAndCombineForLocalReduction(this.mcc);
                return map;
            }
            finally {
                MapReduceTask.this.cancellationService.unregister(this.mcc.getUUID());
                log.debugf("Invoked %s locally", this.mcc);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<KOut> invokeMapCombineLocally() throws InterruptedException {
            log.debugf("Invoking %s locally", this.mcc);
            try {
                MapReduceTask.this.cancellationService.register(Thread.currentThread(), this.mcc.getUUID());
                this.mcc.init(MapReduceTask.this.mapReduceManager);
                Set set = MapReduceTask.this.mapReduceManager.mapAndCombineForDistributedReduction(this.mcc);
                return set;
            }
            finally {
                MapReduceTask.this.cancellationService.unregister(this.mcc.getUUID());
                log.debugf("Invoked %s locally", this.mcc);
            }
        }

        @Override
        public UUID getUUID() {
            return this.mcc.getUUID();
        }
    }

    private abstract class TaskPart<V>
    implements NotifyingNotifiableFuture<V>,
    CancellableTaskPart {
        private Future<V> f;
        private final Address executionTarget;

        public TaskPart(Address executionTarget) {
            this.executionTarget = executionTarget;
        }

        @Override
        public Address getExecutionTarget() {
            return this.executionTarget;
        }

        @Override
        public NotifyingFuture<V> attachListener(FutureListener<V> listener) {
            return this;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }

        @Override
        public boolean isCancelled() {
            return false;
        }

        @Override
        public boolean isDone() {
            return false;
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.retrieveResult(this.f.get());
        }

        protected Address getAddress() {
            return MapReduceTask.this.clusteringDependentLogic.getAddress();
        }

        protected boolean locallyExecuted() {
            return this.getAddress().equals(this.getExecutionTarget());
        }

        public abstract void execute();

        private V retrieveResult(Object response) throws ExecutionException {
            if (response == null) {
                throw new ExecutionException("Execution returned null value", new NullPointerException());
            }
            if (response instanceof Exception) {
                throw new ExecutionException((Exception)response);
            }
            Map mapResult = (Map)response;
            assert (mapResult.size() == 1);
            for (Map.Entry e : mapResult.entrySet()) {
                if (!(e.getValue() instanceof SuccessfulResponse)) continue;
                return (V)((SuccessfulResponse)e.getValue()).getResponseValue();
            }
            throw new ExecutionException(new IllegalStateException("Invalid response " + response));
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.retrieveResult(this.f.get(timeout, unit));
        }

        @Override
        public void notifyDone() {
        }

        @Override
        public void setNetworkFuture(Future<V> future) {
            this.f = future;
        }
    }

    private class MapReduceTaskFuture<R>
    extends AbstractInProcessFuture<R> {
        private final Callable<R> call;
        private volatile boolean cancelled = false;
        private volatile boolean done = false;

        public MapReduceTaskFuture(Callable<R> call) {
            this.call = call;
        }

        @Override
        public R get() throws InterruptedException, ExecutionException {
            if (this.isCancelled()) {
                throw new CancellationException("MapReduceTask already cancelled");
            }
            try {
                R r = this.call.call();
                return r;
            }
            catch (Exception e) {
                throw new ExecutionException(e);
            }
            finally {
                this.done = true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (!this.isCancelled()) {
                RpcManager rpc = MapReduceTask.this.cache.getRpcManager();
                List<CancellableTaskPart> list = MapReduceTask.this.cancellableTasks;
                synchronized (list) {
                    for (CancellableTaskPart task : MapReduceTask.this.cancellableTasks) {
                        boolean sendingToSelf = task.getExecutionTarget().equals(rpc.getTransport().getAddress());
                        CancelCommand cc = MapReduceTask.this.buildCancelCommand(task);
                        if (sendingToSelf) {
                            cc.init(MapReduceTask.this.cancellationService);
                            try {
                                cc.perform(null);
                            }
                            catch (Throwable e) {
                                log.couldNotExecuteCancellationLocally(e.getLocalizedMessage());
                            }
                        } else {
                            rpc.invokeRemotely(Collections.singletonList(task.getExecutionTarget()), (ReplicableCommand)cc, MapReduceTask.this.rpcOptionsBuilder.build());
                        }
                        this.cancelled = true;
                        this.done = true;
                    }
                }
                return this.cancelled;
            }
            return false;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }
    }
}

