/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.eviction;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.impl.ImmutableContext;
import org.infinispan.eviction.PassivationManager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.factories.annotations.Stop;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.manager.CacheLoaderManager;
import org.infinispan.loaders.spi.CacheStore;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class PassivationManagerImpl
implements PassivationManager {
    CacheLoaderManager cacheLoaderManager;
    CacheNotifier notifier;
    CacheStore cacheStore;
    Configuration cfg;
    boolean statsEnabled = false;
    boolean enabled = false;
    private static final Log log = LogFactory.getLog(PassivationManagerImpl.class);
    private final AtomicLong passivations = new AtomicLong(0L);
    private DataContainer container;
    private TimeService timeService;
    private static final boolean trace = log.isTraceEnabled();

    @Inject
    public void inject(CacheLoaderManager cacheLoaderManager, CacheNotifier notifier, Configuration cfg, DataContainer container, TimeService timeService) {
        this.cacheLoaderManager = cacheLoaderManager;
        this.notifier = notifier;
        this.cfg = cfg;
        this.container = container;
        this.timeService = timeService;
    }

    @Start(priority=12)
    public void start() {
        this.enabled = this.cacheLoaderManager.isUsingPassivation();
        if (this.enabled) {
            CacheStore cacheStore = this.cacheStore = this.cacheLoaderManager == null ? null : this.cacheLoaderManager.getCacheStore();
            if (this.cacheStore == null) {
                throw new CacheConfigurationException("passivation can only be used with a CacheLoader that implements CacheStore!");
            }
            this.enabled = this.cacheLoaderManager.isEnabled() && this.cacheLoaderManager.isUsingPassivation();
            this.statsEnabled = this.cfg.jmxStatistics().enabled();
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void passivate(InternalCacheEntry entry) {
        if (this.enabled && entry != null) {
            Object key = entry.getKey();
            this.notifier.notifyCacheEntryPassivated(key, entry.getValue(), true, ImmutableContext.INSTANCE, null);
            if (trace) {
                log.tracef("Passivating entry %s", key);
            }
            try {
                this.cacheStore.store(entry);
                if (this.statsEnabled) {
                    this.passivations.getAndIncrement();
                }
            }
            catch (CacheLoaderException e) {
                log.unableToPassivateEntry(key, e);
            }
            this.notifier.notifyCacheEntryPassivated(key, null, false, ImmutableContext.INSTANCE, null);
        }
    }

    @Override
    @Stop(priority=9)
    public void passivateAll() throws CacheLoaderException {
        if (this.enabled) {
            long start = this.timeService.time();
            log.passivatingAllEntries();
            for (InternalCacheEntry e : this.container) {
                if (trace) {
                    log.tracef("Passivating %s", e.getKey());
                }
                this.cacheStore.store(e);
            }
            log.passivatedEntries(this.container.size(), Util.prettyPrintTime(this.timeService.timeDuration(start, TimeUnit.MILLISECONDS)));
        }
    }

    @Override
    public long getPassivationCount() {
        return this.passivations.get();
    }

    @Override
    public void resetPassivationCount() {
        this.passivations.set(0L);
    }
}

