/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.concurrent.TimeUnit;
import org.infinispan.Cache;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.transaction.xa.recovery.RecoveryAwareRemoteTransaction;
import org.infinispan.transaction.xa.recovery.RecoveryInfoKey;
import org.infinispan.transaction.xa.recovery.RecoveryManager;
import org.infinispan.transaction.xa.recovery.RecoveryManagerImpl;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={RecoveryManager.class})
public class RecoveryManagerFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(RecoveryManagerFactory.class);
    private static final long DEFAULT_EXPIRY = TimeUnit.HOURS.toMillis(6L);

    public <RecoveryManager> RecoveryManager construct(Class<RecoveryManager> componentType) {
        boolean recoveryEnabled;
        boolean bl = recoveryEnabled = this.configuration.transaction().recovery().enabled() && !this.configuration.transaction().useSynchronization();
        if (recoveryEnabled) {
            String recoveryCacheName = this.configuration.transaction().recovery().recoveryInfoCacheName();
            log.tracef("Using recovery cache name %s", recoveryCacheName);
            EmbeddedCacheManager cm = this.componentRegistry.getGlobalComponentRegistry().getComponent(EmbeddedCacheManager.class);
            boolean useDefaultCache = recoveryCacheName.equals("__recoveryInfoCacheName__");
            if (!useDefaultCache) {
                if (!cm.getCacheNames().contains(recoveryCacheName)) {
                    throw new CacheConfigurationException("Recovery cache (" + recoveryCacheName + ") does not exist!!");
                }
            } else if (!cm.getCacheNames().contains(recoveryCacheName)) {
                Configuration config = this.getDefaultRecoveryCacheConfig();
                cm.defineConfiguration(recoveryCacheName, config);
            }
            return (RecoveryManager)this.buildRecoveryManager(this.componentRegistry.getCacheName(), recoveryCacheName, cm, useDefaultCache);
        }
        return null;
    }

    private Configuration getDefaultRecoveryCacheConfig() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().transactionMode(TransactionMode.NON_TRANSACTIONAL);
        builder.clustering().cacheMode(CacheMode.LOCAL);
        builder.expiration().lifespan(DEFAULT_EXPIRY);
        builder.transaction().recovery().disable();
        return builder.build();
    }

    private RecoveryManager buildRecoveryManager(String cacheName, String recoveryCacheName, EmbeddedCacheManager cm, boolean isDefault) {
        log.tracef("About to obtain a reference to the recovery cache: %s", recoveryCacheName);
        Cache<RecoveryInfoKey, RecoveryAwareRemoteTransaction> recoveryCache = cm.getCache(recoveryCacheName);
        if (recoveryCache.getCacheConfiguration().transaction().transactionMode().isTransactional()) {
            throw new CacheConfigurationException("The recovery cache shouldn't be transactional.");
        }
        log.tracef("Obtained a reference to the recovery cache: %s", recoveryCacheName);
        return new RecoveryManagerImpl(recoveryCache, cacheName);
    }
}

