/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.interceptors.distribution;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import org.infinispan.atomic.DeltaCompositeKey;
import org.infinispan.commands.FlagAffectedCommand;
import org.infinispan.commands.ReplicableCommand;
import org.infinispan.commands.control.LockControlCommand;
import org.infinispan.commands.read.GetKeyValueCommand;
import org.infinispan.commands.tx.CommitCommand;
import org.infinispan.commands.tx.PrepareCommand;
import org.infinispan.commands.tx.RollbackCommand;
import org.infinispan.commands.write.ClearCommand;
import org.infinispan.commands.write.PutKeyValueCommand;
import org.infinispan.commands.write.PutMapCommand;
import org.infinispan.commands.write.RemoveCommand;
import org.infinispan.commands.write.ReplaceCommand;
import org.infinispan.commands.write.WriteCommand;
import org.infinispan.commons.util.InfinispanCollections;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.context.InvocationContext;
import org.infinispan.context.impl.LocalTxInvocationContext;
import org.infinispan.context.impl.TxInvocationContext;
import org.infinispan.distribution.L1Manager;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.factories.annotations.Start;
import org.infinispan.interceptors.distribution.BaseDistributionInterceptor;
import org.infinispan.metadata.Metadata;
import org.infinispan.remoting.rpc.ResponseMode;
import org.infinispan.remoting.rpc.RpcOptions;
import org.infinispan.remoting.transport.Address;
import org.infinispan.remoting.transport.jgroups.SuspectException;
import org.infinispan.transaction.LocalTransaction;
import org.infinispan.transaction.LockingMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class TxDistributionInterceptor
extends BaseDistributionInterceptor {
    private static Log log = LogFactory.getLog(TxDistributionInterceptor.class);
    private static final boolean trace = log.isTraceEnabled();
    private boolean isPessimisticCache;
    private boolean useClusteredWriteSkewCheck;
    private L1Manager l1Manager;
    private boolean isL1CacheEnabled;
    private static final BaseDistributionInterceptor.RecipientGenerator CLEAR_COMMAND_GENERATOR = new BaseDistributionInterceptor.RecipientGenerator(){

        @Override
        public List<Address> generateRecipients() {
            return null;
        }

        @Override
        public Collection<Object> getKeys() {
            return InfinispanCollections.emptySet();
        }
    };

    @Inject
    public void injectDependencies(L1Manager l1Manager) {
        this.l1Manager = l1Manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitReplaceCommand(InvocationContext ctx, ReplaceCommand command) throws Throwable {
        try {
            Object object = this.handleTxWriteCommand(ctx, command, new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey()), false);
            return object;
        }
        finally {
            boolean ignorePreviousValues = this.ignorePreviousValueOnBackup(command, ctx);
            command.setIgnorePreviousValue(ignorePreviousValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitRemoveCommand(InvocationContext ctx, RemoveCommand command) throws Throwable {
        try {
            Object object = this.handleTxWriteCommand(ctx, command, new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey()), false);
            return object;
        }
        finally {
            boolean ignorePreviousValues = this.ignorePreviousValueOnBackup(command, ctx);
            command.setIgnorePreviousValue(ignorePreviousValues);
        }
    }

    @Start
    public void start() {
        this.isPessimisticCache = this.cacheConfiguration.transaction().lockingMode() == LockingMode.PESSIMISTIC;
        this.isL1CacheEnabled = this.cacheConfiguration.clustering().l1().enabled();
        this.useClusteredWriteSkewCheck = !this.isPessimisticCache && this.cacheConfiguration.versioning().enabled() && this.cacheConfiguration.locking().writeSkewCheck();
    }

    @Override
    public Object visitPutKeyValueCommand(InvocationContext ctx, PutKeyValueCommand command) throws Throwable {
        if (command.hasFlag(Flag.PUT_FOR_EXTERNAL_READ)) {
            return this.handleNonTxWriteCommand(ctx, command);
        }
        BaseDistributionInterceptor.SingleKeyRecipientGenerator skrg = new BaseDistributionInterceptor.SingleKeyRecipientGenerator(command.getKey());
        Object returnValue = this.handleTxWriteCommand(ctx, command, skrg, command.hasFlag(Flag.PUT_FOR_STATE_TRANSFER));
        if (this.ignorePreviousValueOnBackup(command, ctx)) {
            command.setIgnorePreviousValue(true);
            command.setPutIfAbsent(false);
        } else {
            command.setIgnorePreviousValue(false);
        }
        if (this.isL1CacheEnabled && !ctx.isOriginLocal() && !skrg.generateRecipients().contains(ctx.getOrigin())) {
            this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
        }
        return returnValue;
    }

    @Override
    public Object visitPutMapCommand(InvocationContext ctx, PutMapCommand command) throws Throwable {
        return this.handleTxWriteCommand(ctx, command, new BaseDistributionInterceptor.MultipleKeysRecipientGenerator(command.getMap().keySet()), true);
    }

    @Override
    public Object visitClearCommand(InvocationContext ctx, ClearCommand command) throws Throwable {
        return this.handleTxWriteCommand(ctx, command, CLEAR_COMMAND_GENERATOR, false);
    }

    @Override
    public Object visitGetKeyValueCommand(InvocationContext ctx, GetKeyValueCommand command) throws Throwable {
        return this.visitGetCommand(ctx, command, false);
    }

    private Object visitGetCommand(InvocationContext ctx, GetKeyValueCommand command, boolean isGetCacheEntry) throws Throwable {
        try {
            CacheEntry entry;
            boolean skipRemoteGet;
            Object returnValue = this.invokeNextInterceptor(ctx, command);
            if (returnValue != null && this.isL1CacheEnabled && !ctx.isOriginLocal()) {
                this.l1Manager.addRequestor(command.getKey(), ctx.getOrigin());
            }
            boolean bl = skipRemoteGet = (entry = ctx.lookupEntry(command.getKey())) != null && entry.skipRemoteGet();
            if (!skipRemoteGet && returnValue == null && ctx.isOriginLocal()) {
                Object key = command.getKey();
                if (this.needsRemoteGet(ctx, command)) {
                    returnValue = this.remoteGetAndStoreInL1(ctx, key, false, command);
                }
                if (returnValue == null && !ctx.isEntryRemovedInContext(command.getKey())) {
                    returnValue = this.localGet(ctx, key, false, command, isGetCacheEntry);
                }
            }
            return returnValue;
        }
        catch (SuspectException e) {
            return this.visitGetKeyValueCommand(ctx, command);
        }
    }

    protected void lockAndWrap(InvocationContext ctx, Object key, InternalCacheEntry ice, FlagAffectedCommand command) throws InterruptedException {
        boolean skipLocking = this.hasSkipLocking(command);
        long lockTimeout = this.getLockAcquisitionTimeout(command, skipLocking);
        this.lockManager.acquireLock(ctx, key, lockTimeout, skipLocking);
        this.entryFactory.wrapEntryForPut(ctx, key, ice, false, command, false);
    }

    @Override
    public Object visitLockControlCommand(TxInvocationContext ctx, LockControlCommand command) throws Throwable {
        if (ctx.isOriginLocal()) {
            ArrayList<Object> keyToCheckOwners = new ArrayList<Object>(command.getKeys().size());
            for (Object key : command.getKeys()) {
                if (key instanceof DeltaCompositeKey) {
                    keyToCheckOwners.add(((DeltaCompositeKey)key).getDeltaAwareValueKey());
                    continue;
                }
                keyToCheckOwners.add(key);
            }
            List<Address> affectedNodes = this.cdl.getOwners(keyToCheckOwners);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(affectedNodes == null ? this.dm.getConsistentHash().getMembers() : affectedNodes);
            log.tracef("Registered remote locks acquired %s", affectedNodes);
            this.rpcManager.invokeRemotely(affectedNodes, (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(true, false));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    @Override
    public Object visitCommitCommand(TxInvocationContext ctx, CommitCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            Future<?> f = this.flushL1Caches(ctx);
            this.sendCommitCommand(ctx, command);
            this.blockOnL1FutureIfNeeded(f);
        } else if (this.isL1CacheEnabled && !ctx.isOriginLocal() && !ctx.getLockedKeys().isEmpty()) {
            this.blockOnL1FutureIfNeeded(this.flushL1Caches(ctx));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private void blockOnL1FutureIfNeeded(Future<?> f) {
        block3: {
            if (f != null && this.cacheConfiguration.transaction().syncCommitPhase()) {
                try {
                    f.get();
                }
                catch (Exception e) {
                    if (e.getCause() instanceof SuspectException) break block3;
                    this.getLog().failedInvalidatingRemoteCache(e);
                }
            }
        }
    }

    @Override
    public Object visitPrepareCommand(TxInvocationContext ctx, PrepareCommand command) throws Throwable {
        Object retVal = this.invokeNextInterceptor(ctx, command);
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            boolean affectsAllNodes;
            if (command.isOnePhaseCommit()) {
                this.flushL1Caches(ctx);
            }
            List<Address> recipients = (affectsAllNodes = ctx.getCacheTransaction().hasModification(ClearCommand.class)) ? this.dm.getWriteConsistentHash().getMembers() : this.cdl.getOwners(ctx.getAffectedKeys());
            recipients = recipients == null ? this.dm.getWriteConsistentHash().getMembers() : recipients;
            this.prepareOnAffectedNodes(ctx, command, recipients, this.defaultSynchronous);
            ((LocalTxInvocationContext)ctx).remoteLocksAcquired(recipients == null ? this.dm.getWriteConsistentHash().getMembers() : recipients);
        } else if (this.isL1CacheEnabled && command.isOnePhaseCommit() && !ctx.isOriginLocal() && !ctx.getLockedKeys().isEmpty()) {
            this.flushL1Caches(ctx);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void prepareOnAffectedNodes(TxInvocationContext ctx, PrepareCommand command, Collection<Address> recipients, boolean sync) {
        try {
            RpcOptions rpcOptions = sync && command.isOnePhaseCommit() ? this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, false).build() : this.rpcManager.getDefaultRpcOptions(sync);
            this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, rpcOptions);
        }
        finally {
            TxDistributionInterceptor.transactionRemotelyPrepared(ctx);
        }
    }

    @Override
    public Object visitRollbackCommand(TxInvocationContext ctx, RollbackCommand command) throws Throwable {
        if (this.shouldInvokeRemoteTxCommand(ctx)) {
            this.rpcManager.invokeRemotely(this.getCommitNodes(ctx), (ReplicableCommand)command, this.rpcManager.getDefaultRpcOptions(this.cacheConfiguration.transaction().syncRollbackPhase(), false));
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Collection<Address> getCommitNodes(TxInvocationContext ctx) {
        LocalTransaction localTx = (LocalTransaction)ctx.getCacheTransaction();
        List<Address> affectedNodes = this.cdl.getOwners(ctx.getAffectedKeys());
        List<Address> members = this.dm.getConsistentHash().getMembers();
        return localTx.getCommitNodes(affectedNodes, this.rpcManager.getTopologyId(), members);
    }

    private void sendCommitCommand(TxInvocationContext ctx, CommitCommand command) throws TimeoutException, InterruptedException {
        Collection<Address> recipients = this.getCommitNodes(ctx);
        boolean syncCommitPhase = this.cacheConfiguration.transaction().syncCommitPhase();
        RpcOptions rpcOptions = syncCommitPhase ? this.rpcManager.getRpcOptionsBuilder(ResponseMode.SYNCHRONOUS_IGNORE_LEAVERS, false).build() : this.rpcManager.getDefaultRpcOptions(false, false);
        this.rpcManager.invokeRemotely(recipients, (ReplicableCommand)command, rpcOptions);
    }

    private boolean shouldFetchRemoteValuesForWriteSkewCheck(InvocationContext ctx, WriteCommand cmd) {
        if (this.useClusteredWriteSkewCheck && ctx.isInTxScope() && this.dm.isRehashInProgress()) {
            for (Object key : cmd.getAffectedKeys()) {
                if (!this.dm.isAffectedByRehash(key) || this.dataContainer.containsKey(key)) continue;
                return true;
            }
        }
        return false;
    }

    private Object handleTxWriteCommand(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator recipientGenerator, boolean skipRemoteGet) throws Throwable {
        if (ctx.isOriginLocal() && !skipRemoteGet || command.isConditional() || this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command)) {
            this.remoteGetBeforeWrite(ctx, command, recipientGenerator);
        }
        return this.invokeNextInterceptor(ctx, command);
    }

    private Object localGet(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command, boolean isGetCacheEntry) throws Throwable {
        InternalCacheEntry ice = this.dataContainer.get(key);
        if (ice != null) {
            if (isWrite && this.isPessimisticCache && ctx.isInTxScope()) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (!ctx.replaceValue(key, ice)) {
                if (isWrite) {
                    this.lockAndWrap(ctx, key, ice, command);
                } else {
                    ctx.putLookedUpEntry(key, ice);
                }
            }
            return isGetCacheEntry ? ice : ice.getValue();
        }
        return null;
    }

    @Override
    protected void remoteGetBeforeWrite(InvocationContext ctx, WriteCommand command, BaseDistributionInterceptor.RecipientGenerator keygen) throws Throwable {
        if (this.isNeedReliableReturnValues(command) || command.isConditional() || this.shouldFetchRemoteValuesForWriteSkewCheck(ctx, command)) {
            for (Object k : keygen.getKeys()) {
                Object returnValue;
                CacheEntry entry = ctx.lookupEntry(k);
                boolean skipRemoteGet = entry != null && entry.skipRemoteGet();
                if (skipRemoteGet || (returnValue = this.remoteGetAndStoreInL1(ctx, k, true, command)) != null) continue;
                this.localGet(ctx, k, true, command, false);
            }
        }
    }

    private boolean isNotInL1(Object key) {
        return !this.isL1CacheEnabled || !this.dataContainer.containsKey(key);
    }

    private Object remoteGetAndStoreInL1(InvocationContext ctx, Object key, boolean isWrite, FlagAffectedCommand command) throws Throwable {
        boolean isKeyLocalToNode = this.dm.getReadConsistentHash().isKeyLocalToNode(this.rpcManager.getAddress(), key);
        if (ctx.isOriginLocal() && !isKeyLocalToNode && this.isNotInL1(key) || this.dm.isAffectedByRehash(key) && !this.dataContainer.containsKey(key)) {
            if (trace) {
                log.tracef("Doing a remote get for key %s", key);
            }
            boolean acquireRemoteLock = false;
            if (ctx.isInTxScope()) {
                TxInvocationContext txContext = (TxInvocationContext)ctx;
                acquireRemoteLock = isWrite && this.isPessimisticCache && !txContext.getAffectedKeys().contains(key);
            }
            InternalCacheEntry ice = this.retrieveFromRemoteSource(key, ctx, acquireRemoteLock, command, isWrite);
            if (acquireRemoteLock) {
                ((TxInvocationContext)ctx).addAffectedKey(key);
            }
            if (ice != null) {
                if (this.useClusteredWriteSkewCheck && ctx.isInTxScope()) {
                    ((TxInvocationContext)ctx).getCacheTransaction().putLookedUpRemoteVersion(key, ice.getMetadata().version());
                }
                if (this.isL1CacheEnabled) {
                    if (this.dm.isAffectedByRehash(key)) {
                        if (trace) {
                            log.tracef("State transfer in progress for key %s, not storing to L1", new Object[0]);
                        }
                        return ice.getValue();
                    }
                    if (trace) {
                        log.tracef("Caching remotely retrieved entry for key %s in L1", key);
                    }
                    try {
                        long l1Lifespan = this.cacheConfiguration.clustering().l1().lifespan();
                        long lifespan = ice.getLifespan() < 0L ? l1Lifespan : Math.min(ice.getLifespan(), l1Lifespan);
                        Metadata newMetadata = ice.getMetadata().builder().lifespan(lifespan).maxIdle(-1L).build();
                        PutKeyValueCommand put = this.cf.buildPutKeyValueCommand(ice.getKey(), ice.getValue(), newMetadata, command.getFlags());
                        ctx.replaceValue(key, ice);
                        this.lockAndWrap(ctx, key, ice, command);
                        this.invokeNextInterceptor(ctx, put);
                    }
                    catch (Exception e) {
                        log.infof("Unable to store entry %s in L1 cache", key);
                        log.debug("Inability to store in L1 caused by", e);
                    }
                } else if (!ctx.replaceValue(key, ice)) {
                    if (isWrite) {
                        this.lockAndWrap(ctx, key, ice, command);
                    } else {
                        ctx.putLookedUpEntry(key, ice);
                        if (ctx.isInTxScope()) {
                            ((TxInvocationContext)ctx).getCacheTransaction().replaceVersionRead(key, ice.getMetadata().version());
                        }
                    }
                }
                return ice.getValue();
            }
        } else if (trace) {
            log.tracef("Not doing a remote get for key %s since entry is mapped to current node (%s), or is in L1.  Owners are %s", key, this.rpcManager.getAddress(), this.dm.locate(key));
        }
        return null;
    }

    private Future<?> flushL1Caches(InvocationContext ctx) {
        return this.isL1CacheEnabled ? this.l1Manager.flushCacheWithSimpleFuture(ctx.getLockedKeys(), null, ctx.getOrigin(), true) : null;
    }
}

