/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.file;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.configuration.cache.SingleFileCacheStoreConfiguration;
import org.infinispan.container.entries.InternalCacheEntry;
import org.infinispan.container.entries.InternalCacheValue;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.spi.AbstractCacheStore;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class SingleFileCacheStore
extends AbstractCacheStore {
    private static final Log log = LogFactory.getLog(SingleFileCacheStore.class);
    private static final byte[] MAGIC = new byte[]{70, 67, 83, 49};
    private static final byte[] ZERO_INT = new byte[]{0, 0, 0, 0};
    private static final int KEYLEN_POS = 4;
    private static final int KEY_POS = 20;
    private SingleFileCacheStoreConfiguration configuration;
    private FileChannel file;
    private Map<Object, FileEntry> entries;
    private SortedSet<FileEntry> freeList;
    private long filePos = MAGIC.length;

    @Override
    public void init(CacheLoaderConfiguration configuration, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.configuration = this.validateConfigurationClass(configuration, SingleFileCacheStoreConfiguration.class);
        super.init(configuration, cache, m);
    }

    @Override
    public void start() throws CacheLoaderException {
        super.start();
        try {
            File dir;
            File f;
            String location = this.configuration.location();
            if (location == null || location.trim().length() == 0) {
                location = "Infinispan-SingleFileCacheStore";
            }
            if (!((f = new File(location + File.separator + this.cache.getName() + ".dat")).exists() || (dir = f.getParentFile()).exists() || dir.mkdirs())) {
                throw log.directoryCannotBeCreated(dir.getAbsolutePath());
            }
            this.file = new RandomAccessFile(f, "rw").getChannel();
            HashMap entryMap = this.configuration.maxEntries() > 0 ? new LinkedHashMap(16, 0.75f, true) : new HashMap();
            this.entries = Collections.synchronizedMap(entryMap);
            this.freeList = Collections.synchronizedSortedSet(new TreeSet());
            byte[] header = new byte[MAGIC.length];
            if (this.file.read(ByteBuffer.wrap(header), 0L) == MAGIC.length && Arrays.equals(MAGIC, header)) {
                this.rebuildIndex();
            } else {
                this.clear();
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public void stop() throws CacheLoaderException {
        try {
            if (this.file != null) {
                this.file.close();
                this.file = null;
                this.entries = null;
                this.freeList = null;
                this.filePos = MAGIC.length;
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
        super.stop();
    }

    private void rebuildIndex() throws Exception {
        ByteBuffer buf = ByteBuffer.allocate(20);
        while (true) {
            buf.clear().limit(20);
            this.file.read(buf, this.filePos);
            if (buf.remaining() > 0) {
                return;
            }
            buf.flip();
            FileEntry fe = new FileEntry(this.filePos, buf.getInt());
            fe.keyLen = buf.getInt();
            fe.dataLen = buf.getInt();
            fe.expiryTime = buf.getLong();
            this.filePos += (long)fe.size;
            if (fe.keyLen > 0) {
                if (buf.capacity() < fe.keyLen) {
                    buf = ByteBuffer.allocate(fe.keyLen);
                }
                buf.clear().limit(fe.keyLen);
                this.file.read(buf, fe.offset + 20L);
                Object key = this.getMarshaller().objectFromByteBuffer(buf.array(), 0, fe.keyLen);
                this.entries.put(key, fe);
                continue;
            }
            this.freeList.add(fe);
        }
    }

    @Override
    public boolean containsKey(Object key) throws CacheLoaderException {
        return this.entries.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry allocate(int len) {
        SortedSet<FileEntry> sortedSet = this.freeList;
        synchronized (sortedSet) {
            SortedSet<FileEntry> candidates = this.freeList.tailSet(new FileEntry(0L, len));
            Iterator it = candidates.iterator();
            while (it.hasNext()) {
                FileEntry free = (FileEntry)it.next();
                if (free.isLocked()) continue;
                it.remove();
                return free;
            }
            FileEntry fe = new FileEntry(this.filePos, len);
            this.filePos += (long)len;
            return fe;
        }
    }

    private void free(FileEntry fe) throws IOException {
        if (fe != null) {
            this.file.write(ByteBuffer.wrap(ZERO_INT), fe.offset + 4L);
            this.freeList.add(fe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void store(InternalCacheEntry entry) throws CacheLoaderException {
        try {
            byte[] key = this.getMarshaller().objectToByteBuffer(entry.getKey());
            byte[] data = this.getMarshaller().objectToByteBuffer(entry.toInternalCacheValue());
            int len = 20 + key.length + data.length;
            FileEntry fe = this.allocate(len);
            try {
                fe.expiryTime = entry.getExpiryTime();
                fe.keyLen = key.length;
                fe.dataLen = data.length;
                ByteBuffer buf = ByteBuffer.allocate(len);
                buf.putInt(fe.size);
                buf.putInt(fe.keyLen);
                buf.putInt(fe.dataLen);
                buf.putLong(fe.expiryTime);
                buf.put(key);
                buf.put(data);
                buf.flip();
                this.file.write(buf, fe.offset);
                fe = this.entries.put(entry.getKey(), fe);
                if (fe == null) {
                    fe = this.evict();
                }
            }
            finally {
                this.free(fe);
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry evict() {
        if (this.configuration.maxEntries() > 0) {
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                if (this.entries.size() > this.configuration.maxEntries()) {
                    Iterator<FileEntry> it = this.entries.values().iterator();
                    FileEntry fe = it.next();
                    it.remove();
                    return fe;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws CacheLoaderException {
        try {
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                SortedSet<FileEntry> sortedSet = this.freeList;
                synchronized (sortedSet) {
                    for (FileEntry fe : this.entries.values()) {
                        fe.waitUnlocked();
                    }
                    for (FileEntry fe : this.freeList) {
                        fe.waitUnlocked();
                    }
                    this.entries.clear();
                    this.freeList.clear();
                    this.file.truncate(0L);
                    this.file.write(ByteBuffer.wrap(MAGIC), 0L);
                    this.filePos = MAGIC.length;
                }
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public boolean remove(Object key) throws CacheLoaderException {
        try {
            FileEntry fe = this.entries.remove(key);
            this.free(fe);
            return fe != null;
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public InternalCacheEntry load(Object key) throws CacheLoaderException {
        try {
            boolean expired;
            FileEntry fe;
            Map<Object, FileEntry> map = this.entries;
            synchronized (map) {
                fe = this.entries.get(key);
                if (fe == null) {
                    return null;
                }
                expired = fe.isExpired(System.currentTimeMillis());
                if (expired) {
                    this.entries.remove(key);
                }
                fe.lock();
            }
            try {
                if (expired) {
                    this.free(fe);
                    InternalCacheEntry internalCacheEntry = null;
                    return internalCacheEntry;
                }
                byte[] data = new byte[fe.dataLen];
                this.file.read(ByteBuffer.wrap(data), fe.offset + 20L + (long)fe.keyLen);
                return ((InternalCacheValue)this.getMarshaller().objectFromByteBuffer(data)).toInternalCacheEntry(key);
            }
            finally {
                fe.unlock();
            }
        }
        catch (Exception e) {
            throw new CacheLoaderException(e);
        }
    }

    @Override
    public Set<InternalCacheEntry> loadAll() throws CacheLoaderException {
        return this.load(Integer.MAX_VALUE);
    }

    @Override
    public Set<InternalCacheEntry> load(int numEntries) throws CacheLoaderException {
        Set<Object> keys = this.loadAllKeys(null);
        HashSet<InternalCacheEntry> result = new HashSet<InternalCacheEntry>();
        for (Object key : keys) {
            InternalCacheEntry ice = this.load(key);
            if (ice == null) continue;
            result.add(ice);
            if (result.size() < numEntries) continue;
            return result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<Object> loadAllKeys(Set<Object> keysToExclude) throws CacheLoaderException {
        HashSet<Object> result;
        Map<Object, FileEntry> map = this.entries;
        synchronized (map) {
            result = new HashSet<Object>(this.entries.keySet());
        }
        if (keysToExclude != null) {
            result.removeAll(keysToExclude);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void purgeInternal() throws CacheLoaderException {
        long now = System.currentTimeMillis();
        Map<Object, FileEntry> map = this.entries;
        synchronized (map) {
            Iterator<FileEntry> it = this.entries.values().iterator();
            while (it.hasNext()) {
                FileEntry fe = it.next();
                if (!fe.isExpired(now)) continue;
                it.remove();
                try {
                    this.free(fe);
                }
                catch (Exception e) {
                    throw new CacheLoaderException(e);
                }
            }
        }
    }

    @Override
    public void fromStream(ObjectInput inputStream) throws CacheLoaderException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toStream(ObjectOutput outputStream) throws CacheLoaderException {
        throw new UnsupportedOperationException();
    }

    Map<Object, FileEntry> getEntries() {
        return this.entries;
    }

    SortedSet<FileEntry> getFreeList() {
        return this.freeList;
    }

    private static class FileEntry
    implements Comparable<Object> {
        private final long offset;
        private final int size;
        private int keyLen;
        private int dataLen;
        private long expiryTime = -1L;
        private transient int readers = 0;

        private FileEntry(long offset, int size) {
            this.offset = offset;
            this.size = size;
        }

        private synchronized boolean isLocked() {
            return this.readers > 0;
        }

        private synchronized void lock() {
            ++this.readers;
        }

        private synchronized void unlock() {
            --this.readers;
            if (this.readers == 0) {
                this.notifyAll();
            }
        }

        private synchronized void waitUnlocked() {
            while (this.readers > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }

        private boolean isExpired(long now) {
            return this.expiryTime > 0L && this.expiryTime < now;
        }

        @Override
        public int compareTo(Object o) {
            FileEntry fe = (FileEntry)o;
            if (this == fe) {
                return 0;
            }
            int diff = this.size - fe.size;
            return diff != 0 ? diff : (this.offset > fe.offset ? 1 : -1);
        }
    }
}

