/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.keymappers;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.commons.util.Base64;
import org.infinispan.loaders.keymappers.DefaultTwoWayKey2StringMapper;
import org.infinispan.loaders.keymappers.MarshallingTwoWayKey2StringMapper;
import org.infinispan.marshall.core.MarshalledValue;

public class MarshalledValueOrPrimitiveMapper
extends DefaultTwoWayKey2StringMapper
implements MarshallingTwoWayKey2StringMapper {
    private MarshalledValue.Externalizer externalizer;

    @Override
    public void setMarshaller(StreamingMarshaller marshaller) {
        this.externalizer = new MarshalledValue.Externalizer(marshaller);
    }

    @Override
    public String getStringMapping(Object key) {
        if (super.isSupportedType(key.getClass())) {
            return super.getStringMapping(key);
        }
        try {
            MarshalledValue mv = (MarshalledValue)key;
            String serializedObj = this.serializeObj(mv);
            return serializedObj;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception occurred serializing key.", ex);
        }
    }

    @Override
    public Object getKeyMapping(String key) {
        if (super.isSupportedType(key.getClass())) {
            return super.getKeyMapping(key);
        }
        try {
            MarshalledValue obj;
            MarshalledValue mv = obj = this.deserializeObj(key);
            return mv;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Exception occurred deserializing key.", ex);
        }
    }

    private String serializeObj(MarshalledValue mv) throws Exception {
        if (this.externalizer == null) {
            throw new IllegalStateException("Cannot serialize object: undefined marshaller");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        this.externalizer.writeObject((ObjectOutput)oos, mv);
        oos.close();
        return Base64.encodeBytes(baos.toByteArray());
    }

    private MarshalledValue deserializeObj(String key) throws Exception {
        if (this.externalizer == null) {
            throw new IllegalStateException("Cannot deserialize object: undefined marshaller");
        }
        byte[] data = Base64.decode(key);
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
        MarshalledValue mv = this.externalizer.readObject(ois);
        ois.close();
        return mv;
    }

    @Override
    public boolean isSupportedType(Class<?> keyType) {
        return keyType.equals(MarshalledValue.class) || super.isSupportedType(keyType);
    }
}

