/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.loaders.spi;

import org.infinispan.Cache;
import org.infinispan.commons.marshall.StreamingMarshaller;
import org.infinispan.configuration.cache.CacheLoaderConfiguration;
import org.infinispan.loaders.CacheLoaderException;
import org.infinispan.loaders.spi.CacheLoader;
import org.infinispan.util.TimeService;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public abstract class AbstractCacheLoader
implements CacheLoader {
    private static final Log log = LogFactory.getLog(AbstractCacheLoader.class);
    protected volatile StreamingMarshaller marshaller;
    protected volatile Cache<Object, Object> cache;
    protected TimeService timeService;
    protected CacheLoaderConfiguration configuration;

    @Override
    public boolean containsKey(Object key) throws CacheLoaderException {
        return this.load(key) != null;
    }

    @Override
    public void init(CacheLoaderConfiguration config, Cache<?, ?> cache, StreamingMarshaller m) throws CacheLoaderException {
        this.marshaller = m;
        if (config == null) {
            throw log.cacheLoaderConfigurationCannotBeNull();
        }
        this.configuration = config;
        this.cache = cache;
        this.timeService = cache.getAdvancedCache().getComponentRegistry().getTimeService();
    }

    protected final <T extends CacheLoaderConfiguration> T validateConfigurationClass(CacheLoaderConfiguration config, Class<T> klass) {
        if (klass.isInstance(config)) {
            return (T)config;
        }
        throw log.incompatibleLoaderConfiguration(klass.getName(), config.getClass().getName());
    }

    @Override
    public CacheLoaderConfiguration getConfiguration() {
        return this.configuration;
    }
}

