/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.registry;

import java.util.HashSet;
import java.util.Set;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.registry.ClusterRegistry;
import org.infinispan.registry.ScopedKey;
import org.infinispan.transaction.TransactionMode;

@ThreadSafe
public class ClusterRegistryImpl<S, K, V>
implements ClusterRegistry<S, K, V> {
    public static final String GLOBAL_REGISTRY_CACHE_NAME = "__cluster_registry_cache__";
    private EmbeddedCacheManager cacheManager;
    private Cache<ScopedKey<S, K>, V> clusterRegistryCache;

    @Inject
    public void init(EmbeddedCacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public V put(S scope, K key, V value) {
        if (value == null) {
            throw new IllegalArgumentException("Null value not allowed!");
        }
        this.startRegistryCache();
        return this.clusterRegistryCache.put(new ScopedKey<S, K>(scope, key), value);
    }

    @Override
    public V remove(S scope, K key) {
        this.startRegistryCache();
        return this.clusterRegistryCache.remove(new ScopedKey<S, K>(scope, key));
    }

    @Override
    public V get(S scope, K key) {
        this.startRegistryCache();
        return this.clusterRegistryCache.get(new ScopedKey<S, K>(scope, key));
    }

    @Override
    public Set<K> keys(S scope) {
        this.startRegistryCache();
        HashSet<K> result = new HashSet<K>();
        for (ScopedKey<S, K> key : this.clusterRegistryCache.keySet()) {
            if (!key.hasScope(scope)) continue;
            result.add(key.getKey());
        }
        return result;
    }

    @Override
    public void clear(S scope) {
        this.startRegistryCache();
        for (ScopedKey<S, K> key : this.clusterRegistryCache.keySet()) {
            if (!key.hasScope(scope)) continue;
            this.clusterRegistryCache.remove(key);
        }
    }

    @Override
    public void clearAll() {
        this.startRegistryCache();
        this.clusterRegistryCache.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startRegistryCache() {
        if (this.clusterRegistryCache == null) {
            ClusterRegistryImpl clusterRegistryImpl = this;
            synchronized (clusterRegistryImpl) {
                if (this.clusterRegistryCache != null) {
                    return;
                }
                this.cacheManager.defineConfiguration(GLOBAL_REGISTRY_CACHE_NAME, this.getRegistryCacheConfig());
                this.clusterRegistryCache = this.cacheManager.getCache(GLOBAL_REGISTRY_CACHE_NAME);
            }
        }
    }

    private Configuration getRegistryCacheConfig() {
        ConfigurationBuilder configurationBuilder = new ConfigurationBuilder();
        CacheMode cacheMode = this.isClustered() ? CacheMode.REPL_SYNC : CacheMode.LOCAL;
        configurationBuilder.clustering().cacheMode(cacheMode);
        configurationBuilder.transaction().transactionMode(TransactionMode.TRANSACTIONAL);
        configurationBuilder.clustering().stateTransfer().fetchInMemoryState(true);
        return configurationBuilder.build();
    }

    private boolean isClustered() {
        GlobalConfiguration globalConfiguration = this.cacheManager.getGlobalComponentRegistry().getGlobalConfiguration();
        return globalConfiguration.isClustered();
    }
}

